package test.org.seasar.util;

import junit.framework.*;
import org.seasar.util.*;

public class SeasarExceptionTest extends TestCase {

    public SeasarExceptionTest(String name) {
        super(name);
    }

    public void testSeasarException() throws Exception {
        SeasarException ex = new SeasarException("ISSR0001");
        assertEquals("1", "ISSR0001", ex.getMessageCode());
        assertEquals("2", getClass().getName(), ex.getClassName());
        assertEquals("3", "testSeasarException", ex.getMethodName());
        assertEquals("4", "[ISSR0001]seasar started", ex.getMessage());
    }

    public void testGetCause() throws Exception {
        try {
            throw new NullPointerException("test");
        } catch (Exception ex) {
            try {
                throw new SeasarException("ESSR0017", new Object[]{ex}, ex);
            } catch (SeasarException ce) {
                assertNotNull("1", ce.getCause());
                ce.printStackTrace();
            }
        }
    }
    
    public void testSerialize() throws Exception {
        SeasarException ex = new SeasarException("ISSR0001");
        SeasarException copy = (SeasarException) Serializer.serialize(ex);
        copy.printStackTrace();
    }

    protected void setUp() throws Exception { }

    protected void tearDown() throws Exception { }

    public static Test suite() {
        return new TestSuite(SeasarExceptionTest.class);
    }

    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{SeasarExceptionTest.class.getName()});
    }
}
