package test.org.seasar.util;

import junit.framework.*;
import java.util.*;
import org.seasar.util.*;

public class EArrayStackTest extends TestCase {

    private EArrayStack _stack;

    public EArrayStackTest(String name) {
        super(name);
    }

    public void testEmpty() throws Exception {
        assertTrue("1", _stack.empty());
        _stack.push("test1");
        assertTrue("2", !_stack.empty());
    }

    public void testPush() throws Exception {
        String s = "test1";
        assertEquals("1", s, _stack.push(s));
        assertEquals("2", 1, _stack.size());
    }

    public void testPop() throws Exception {
        String s = "test1";
        _stack.push(s);
        assertEquals("1", s, _stack.pop());
        assertEquals("2", 0, _stack.size());
        try {
            _stack.pop();
            fail("3");
        } catch (EmptyStackException ex) {
            System.out.println(ex);
        }
    }

    public void testPeek() throws Exception {
        try {
            _stack.peek();
            fail("1");
        } catch (EmptyStackException ex) {
            System.out.println(ex);
        }
        String s = "test1";
        String s2 = "test2";
        _stack.push(s);
        _stack.push(s2);
        assertEquals("2", s2, _stack.peek());
        assertEquals("3", 2, _stack.size());
        assertEquals("4", s, _stack.peek(1));
        try {
            _stack.peek(2);
            fail("5");
        } catch (EmptyStackException ex) {
            System.out.println(ex);
        }
    }

    public void testSearch() throws Exception {
        String s = "test1";
        String s2 = "test2";
        _stack.push(s);
        _stack.push(s2);
        _stack.push(s);
        assertEquals("1", 1, _stack.search(s));
        assertEquals("2", 2, _stack.search(s2));
        assertEquals("3", -1, _stack.search("dummy"));
    }

    public void testPerformance() throws Exception {
        int num = 1000000;
        Stack s = new Stack();
        EArrayStack eas = new EArrayStack();

        long start = System.currentTimeMillis();
        for (int i = 0; i < num; i++) {
            s.push("aaa");
        }
        System.out.println("Stack.push:" + (System.currentTimeMillis() - start));

        start = System.currentTimeMillis();
        for (int i = 0; i < num; i++) {
            eas.push("aaa");
        }
        System.out.println("EArrayStack.push:" + (System.currentTimeMillis() - start));

        start = System.currentTimeMillis();
        for (int i = 0; i < num; i++) {
            s.pop();
        }
        System.out.println("Stack.pop:" + (System.currentTimeMillis() - start));

        start = System.currentTimeMillis();
        for (int i = 0; i < num; i++) {
            eas.pop();
        }
        System.out.println("EArrayStack.pop:" + (System.currentTimeMillis() - start));
    }

    protected void setUp() throws Exception {
        _stack = new EArrayStack();
    }

    protected void tearDown() throws Exception {
        _stack = null;
    }

    public static Test suite() {
        return new TestSuite(EArrayStackTest.class);
    }

    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{EArrayStackTest.class.getName()});
    }
}
