package test.org.seasar.transaction;

import junit.framework.*;
import javax.transaction.*;
import org.seasar.transaction.*;

public class TransactionManagerImplTest extends TestCase {

    public TransactionManagerImplTest(String name) {
        super(name);
    }

    public void testResume() throws Exception {
        TransactionManagerImpl.getInstance().begin();
        TransactionManagerImpl.getInstance().commit();

        UserTransactionImpl.getInstance().begin();
        Transaction tx = TransactionManagerImpl.getInstance().suspend();
        TransactionManagerImpl.getInstance().begin();
        TransactionManagerImpl.getInstance().commit();
        TransactionManagerImpl.getInstance().resume(tx);
        UserTransactionImpl.getInstance().commit();
    }

    public void testCommit() throws Exception {
        TransactionManagerImpl.getInstance().begin();
        TransactionManagerImpl.getInstance().commit();
        assertEquals("1", Status.STATUS_NO_TRANSACTION,
        	TransactionManagerImpl.getInstance().getStatus());
    }

    public void testRollback() throws Exception {
        TransactionManagerImpl.getInstance().begin();
        TransactionManagerImpl.getInstance().rollback();
        assertEquals("1", Status.STATUS_NO_TRANSACTION,
        	TransactionManagerImpl.getInstance().getStatus());
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(TransactionManagerImplTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{TransactionManagerImplTest.class.getName()});
    }
}