package test.org.seasar.system;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.system.RMIAdaptorService;
import org.seasar.system.Seasar;

public class SeasarTest extends TestCase {

    public SeasarTest(String name) {
        super(name);
    }

    public void testConfig() throws Throwable {
    	Seasar.configure();
        assertEquals("1", 0, RMIAdaptorService.getInstance().getPort());
    }
	
    public void testStartStop() throws Exception {
        for (int i = 0; i < 100; i++) {
            System.out.println(i + " times");
            Seasar.getInstance().start();
            Seasar.getInstance().stop();
        }
    }
    
	public void testRetartService() throws Exception {
		Seasar.getInstance().start();
		try {
			Seasar.getInstance().restartService("org.seasar.sql.ConnectionPoolService");
		} finally {
			Seasar.getInstance().stop();
		}
	}

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(SeasarTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{SeasarTest.class.getName()});
    }
}