package test.org.seasar.system;

import java.rmi.server.UnicastRemoteObject;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.seasar.system.JMXService;
import org.seasar.system.RMINotificationListener;
import org.seasar.system.RMINotificationListenerAdaptor;
import org.seasar.system.RMINotificationListenerServerAdaptor;
import org.seasar.util.SeasarContext;

public class RMINotificationListenerServerAdaptorTest extends RMIAdaptorTestCase {

  	public RMINotificationListenerServerAdaptorTest(String name) {
    	super(name);
  	}

  	public void testNotify() throws Throwable {
  		Notify notify = new Notify();
  		JMXService.registerMBean(notify, NotifyMBean.NAME);
    	
    	NotificationListenerTester listenerTester = new NotificationListenerTester();
    	RMINotificationListenerAdaptor rmiListenerAdaptor =
    		new RMINotificationListenerAdaptor(NotifyMBean.NAME, listenerTester,
    		SeasarContext.getInstance("test"));
    	RMINotificationListener stub = (RMINotificationListener)
    		UnicastRemoteObject.exportObject(rmiListenerAdaptor);
    	
    	RMINotificationListenerServerAdaptor serverAdaptor =
    		new RMINotificationListenerServerAdaptor(NotifyMBean.NAME, stub);
    	serverAdaptor.addNotificationListener();
    	assertEquals("1", true, JMXService.isRegistered(serverAdaptor.getListenerName()));
    	
    	notify.sendMessage("Hello");
    	assertEquals("2", true, listenerTester.isCalled());
    	
    	serverAdaptor.removeNotificationListener();
    	assertEquals("3", false, JMXService.isRegistered(serverAdaptor.getListenerName()));
  	}
  	

  	protected void setUp() throws Exception {
  		super.setUp();
  	}

  	protected void tearDown() throws Exception {
  		super.tearDown();
  	}

  	public static Test suite ( ) {
    	return new TestSuite(RMINotificationListenerServerAdaptorTest.class);
  	}

  	public static void main (String[] args) {
    	junit.textui.TestRunner.main(new String[]{RMINotificationListenerServerAdaptorTest.class.getName()});
  	}
}