package test.org.seasar.nazuna;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.seasar.nazuna.Flowlet;
import org.seasar.nazuna.FlowletBuilder;
import org.seasar.util.SeasarContext;
import org.seasar.util.SeasarException;

import test.org.seasar.transaction.TransactionTestCase;

public class TransAttributeTest extends TransactionTestCase {

    public TransAttributeTest(String name) {
        super(name);
    }
    
    
    public void testRequiredTransaction() throws Exception {
    	String xmlFileName = "/test/org/seasar/nazuna/Transaction.xml";
    	Flowlet rule = FlowletBuilder.parse(xmlFileName);
    	assertEquals("1", Boolean.TRUE, rule.execute());
    }
    
    public void testRequiresNewTransaction() throws Exception {
    	String xmlFileName = "/test/org/seasar/nazuna/Transaction2.xml";
    	Flowlet rule = FlowletBuilder.parse(xmlFileName);
    	SeasarContext.getInstance().begin();
    	assertEquals("1", Boolean.TRUE, rule.execute());
    	SeasarContext.getInstance().commit();
    }
    
    public void testMandatoryTransaction() throws Exception {
    	String xmlFileName = "/test/org/seasar/nazuna/Transaction3.xml";
    	Flowlet rule = FlowletBuilder.parse(xmlFileName);
    	SeasarContext.getInstance().begin();
    	assertEquals("2", Boolean.TRUE, rule.execute());
    	SeasarContext.getInstance().commit();
    }
    
    public void testMandatoryTransaction2() throws Exception {
    	String xmlFileName = "/test/org/seasar/nazuna/Transaction3.xml";
    	Flowlet rule = FlowletBuilder.parse(xmlFileName);
    	try {
    		rule.execute();
    		fail("1");
    	} catch (SeasarException ex) {
    		System.out.println(ex);
    	}
    }

    protected void setUp() throws Exception {
    	super.setUp();
    }

    protected void tearDown() throws Exception {
    	super.tearDown();
    }

    public static Test suite ( ) {
        return new TestSuite(TransAttributeTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{TransAttributeTest.class.getName()});
    }
}