package test.org.seasar.nazuna;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.seasar.nazuna.NzRecordSet;
import org.seasar.nazuna.Sqlet;
import org.seasar.nazuna.SqletContainer;
import org.seasar.util.Conversion;
import org.seasar.util.SeasarContext;
import org.seasar.util.SeasarException;

import test.org.seasar.sql.ConnectionPoolTestCase;

public class SqletTest extends ConnectionPoolTestCase {

	public SqletTest(String name) {
		super(name);
	}

	public void testExecuteQuery() throws Exception {
		String name = "test.org.seasar.nazuna.select";
		Sqlet sqlet = SqletContainer.getSqlet(name);
		List results = sqlet.executeQuery();
		assertEquals("1", 14, results.size());
		Employee employee = (Employee) results.get(0);
		assertEquals("2", 7369, employee.getEmployeeNo());
		assertEquals("3", "SMITH", employee.getEmployeeName());
		assertEquals("4", "CLERK", employee.getJob());
		assertEquals("5", 7902, employee.getManager());
		assertEquals(
			"6",
			Conversion.toTimestamp("19801217", "yyyyMMdd"),
			employee.getHireDate());
		assertEquals("7", 800.0, employee.getSalary(), 0);
		assertEquals("8", null, employee.getCommission());
		assertEquals("9", 20, employee.getDepartmentNo());
	}

	public void testExecuteQuery2() throws Exception {
		String name = "test.org.seasar.nazuna.select2";
		Sqlet sqlet = SqletContainer.getSqlet(name);
		List results = sqlet.executeQuery();
		assertEquals("1", 14, results.size());

		Map parameters = new HashMap();
		parameters.put("empno", new Integer(7369));
		List results2 = sqlet.executeQuery(parameters);
		assertEquals("2", 1, results2.size());
	}

	public void testExecuteQuery3() throws Exception {
		String name = "/test/org/seasar/nazuna/select3.xml";
		Sqlet sqlet = SqletContainer.getSqlet(name);
		List results = sqlet.executeQuery();
		assertEquals("1", 14, results.size());
		Map employee = (Map) results.get(0);
		assertEquals("2", new Integer(7369), employee.get("EmployeeNo"));
		assertEquals("3", "SMITH", employee.get("EmployeeName"));
		assertEquals("4", "CLERK", employee.get("Job"));
		assertEquals("5", new Integer(7902), employee.get("Manager"));
		assertEquals(
			"6",
			Conversion.toTimestamp("19801217", "yyyyMMdd"),
			employee.get("HireDate"));
		assertEquals("7", new Double(800), employee.get("Salary"));
		assertEquals("8", null, employee.get("Commission"));
		assertEquals("9", new Integer(20), employee.get("DepartmentNo"));
	}

	public void testExecuteQuery4() throws Exception {
		String name = "test.org.seasar.nazuna.select4";
		Sqlet sqlet = SqletContainer.getSqlet(name);
		List results = sqlet.executeQuery();
		assertEquals("1", 14, results.size());
		Map employee = (Map) results.get(0);
		System.out.println(employee);
		assertEquals("2", new Double(7369), employee.get("EMPNO"));
		assertEquals("3", "SMITH", employee.get("ENAME"));
		assertEquals("4", "CLERK", employee.get("JOB"));
		assertEquals("5", new Double(7902), employee.get("MGR"));
		assertEquals(
			"6",
			Conversion.toTimestamp("19801217", "yyyyMMdd"),
			employee.get("HIREDATE"));
		assertEquals("7", new Double(800.0), employee.get("SAL"));
		assertEquals("8", new Double(0.0), employee.get("COMM"));
		assertEquals("9", new Double(20), employee.get("DEPTNO"));
	}

	public void testExecuteUpdate() throws Exception {
		SeasarContext ctx = SeasarContext.getInstance();
		ctx.begin();
		try {
			String name = "/test/org/seasar/nazuna/update.xml";
			Sqlet sqlet = SqletContainer.getSqlet(name);
			Employee employee = new Employee();
			employee.setEmployeeNo(7369);
			employee.setEmployeeName("SMITH2");
			Map parameters = new HashMap();
			parameters.put("employee", employee);
			assertEquals("1", 1, sqlet.executeUpdate(parameters));

			String name2 = "/test/org/seasar/nazuna/select2.xml";
			Sqlet sqlet2 = SqletContainer.getSqlet(name2);
			Map parameters2 = new HashMap();
			parameters2.put("empno", new Integer(7369));
			List results = sqlet2.executeQuery(parameters2);
			Employee employee2 = (Employee) results.get(0);
			assertEquals("2", "SMITH2", employee2.getEmployeeName());
		} finally {
			ctx.rollback();
		}
	}

	public void testExecuteRSQuery() throws Exception {
		String name = "test.org.seasar.nazuna.select";
		Sqlet sqlet = SqletContainer.getSqlet(name);
		NzRecordSet rs = sqlet.executeRSQuery();
		List results = rs.getRows();
		assertEquals("1", 14, results.size());
		Employee employee = (Employee) results.get(0);
		assertEquals("2", 7369, employee.getEmployeeNo());
		assertEquals("3", "SMITH", employee.getEmployeeName());
		assertEquals("4", "CLERK", employee.getJob());
		assertEquals("5", 7902, employee.getManager());
		assertEquals(
			"6",
			Conversion.toTimestamp("19801217", "yyyyMMdd"),
			employee.getHireDate());
		assertEquals("7", 800.0, employee.getSalary(), 0);
		assertEquals("8", null, employee.getCommission());
		assertEquals("9", 20, employee.getDepartmentNo());
		String[] propertyNames = rs.getPropertyNames();
		assertEquals("10", 8, propertyNames.length);
		assertEquals("11", "EmployeeNo", propertyNames[0]);
		assertEquals("12", "EmployeeName", propertyNames[1]);
		assertEquals("13", "Job", propertyNames[2]);
		assertEquals("14", "Manager", propertyNames[3]);
		assertEquals("15", "HireDate", propertyNames[4]);
		assertEquals("16", "Salary", propertyNames[5]);
		assertEquals("17", "Commission", propertyNames[6]);
		assertEquals("18", "DepartmentNo", propertyNames[7]);
	}

	public void testExecuteSingleQuery() throws Exception {
		String name = "test.org.seasar.nazuna.select2";
		Sqlet sqlet = SqletContainer.getSqlet(name);
		Map parameters = new HashMap();
		parameters.put("empno", new Integer(7369));
		Object result = sqlet.executeSingleQuery(parameters);
		assertNotNull("1", result);
	}

	public void testExecuteSingleQuery2() throws Exception {
		String name = "test.org.seasar.nazuna.select2";
		Sqlet sqlet = SqletContainer.getSqlet(name);
		Map parameters = new HashMap();
		parameters.put("empno", new Integer(-1));
		Object result = sqlet.executeSingleQuery(parameters);
		assertNull("1", result);
	}

	public void testExecuteSingleQuery3() throws Exception {
		String name = "test.org.seasar.nazuna.select";
		Sqlet sqlet = SqletContainer.getSqlet(name);
		try {
			sqlet.executeSingleQuery();
			fail("1");
		} catch (SeasarException ex) {
			if (ex.getMessageCode().equals("ESSR0362")) {
				System.out.println(ex);
			} else {
				throw ex;
			}
		}
	}

	protected void setUp() throws Exception {
		super.setUp();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public static Test suite() {
		return new TestSuite(SqletTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(new String[] { SqletTest.class.getName()});
	}
}