package test.org.seasar.nazuna;

import java.io.File;
import java.util.Date;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.Sqlet;
import org.seasar.nazuna.SqletDeployer;
import org.seasar.util.ResourceUtil;

public class SqletDeployerTest extends TestCase {
		
    public SqletDeployerTest(String name) {
        super(name);
    }
    
    public void testDeploy() throws Exception {
    	String name = "test.org.seasar.nazuna.select";
    	SqletDeployer deployer = new SqletDeployer(name);
    	File file = ResourceUtil.getFile(name, "xml");
    	deployer.deploy();
    	Sqlet sqlet = deployer.getSqlet();
    	assertNotNull("1", sqlet);
    	assertEquals("2", file.lastModified(),
    		deployer.getLastModified());
        Thread.sleep(1000);
        long now = new Date().getTime();
        file.setLastModified(now);
        deployer.deploy();
    	assertEquals("3", now, deployer.getLastModified());
        assertTrue("4", sqlet != deployer.getSqlet());
    }
        
    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(SqletDeployerTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{SqletDeployerTest.class.getName()});
    }
}