package test.org.seasar.nazuna;

import java.util.Map;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.ArgType;
import org.seasar.nazuna.Flowlet;
import org.seasar.nazuna.InputType;
import org.seasar.nazuna.RuleContextImpl;
import org.seasar.nazuna.SetVariableExp;
import org.seasar.nazuna.StringExp;
import org.seasar.util.EMap;

public class SetVariableExpTest extends TestCase {

    public SetVariableExpTest(String name) {
        super(name);
    }

    public void testEvaluateValue() throws Exception {
    	Flowlet rule = new Flowlet();
    	InputType inputType = new InputType();
    	ArgType argType = new ArgType("mybean", MyBean.class);
    	inputType.addArgType(argType);
    	rule.setInputType(inputType);
    	
    	MyBean myBean = new MyBean();
    	Map parameters = new EMap();
    	parameters.put("mybean", myBean);
        SetVariableExp varExp = new SetVariableExp("mybean.aaa", new StringExp("bbb"));
        assertEquals("1", "bbb", varExp.evaluateValue(new RuleContextImpl(rule, parameters)));
        assertEquals("2", "bbb", myBean.getAaa());
    }
    
    public void testEvaluateValue2() throws Exception {
    	Flowlet rule = new Flowlet();
    	InputType inputType = new InputType();
    	ArgType argType = new ArgType("map", Map.class);
    	inputType.addArgType(argType);
    	rule.setInputType(inputType);
    	
    	Map parameters = new EMap();
    	Map map = new EMap();
    	map.put("aaa", "test");
    	parameters.put("map", map);
    	SetVariableExp varExp = new SetVariableExp("map.aaa", new StringExp("bbb"));
        assertEquals("1", "bbb", varExp.evaluateValue(new RuleContextImpl(rule, parameters)));
        assertEquals("2", "bbb", map.get("aaa"));
    }
    
    public void testEvaluateValue3() throws Exception {
    	Flowlet rule = new Flowlet();
    	InputType inputType = new InputType();
    	ArgType argType = new ArgType("map2", Map.class);
    	inputType.addArgType(argType);
    	rule.setInputType(inputType);
    	
    	Map parameters = new EMap();
    	Map map = new EMap();
    	map.put("aaa", "test");
    	Map map2 = new EMap();
    	map2.put("map", map);
    	parameters.put("map2", map2);
        SetVariableExp varExp = new SetVariableExp("map2.map.aaa", new StringExp("bbb"));
        assertEquals("1", "bbb", varExp.evaluateValue(new RuleContextImpl(rule, parameters)));
        assertEquals("2", "bbb", map.get("aaa"));
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(SetVariableExpTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{SetVariableExpTest.class.getName()});
    }
    
    public static class MyBean {
    	
    	private String _aaa = "test";
    	
    	public String getAaa() {
    		return _aaa;
    	}
    	
    	public void setAaa(String aaa) {
    		_aaa = aaa;
    	}
    }
}