package test.org.seasar.nazuna;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.ResultType;
import org.seasar.nazuna.ResultTypeFactory;

public class ResultTypeFactoryTest extends TestCase {

    public ResultTypeFactoryTest(String name) {
        super(name);
    }

    public void testGetResultType() throws Exception {
    	String xmlFileName = "/test/org/seasar/nazuna/Employee.xml";
    	ResultType rt = ResultTypeFactory.getResultType(xmlFileName);
        assertNotNull("1", rt);
        ResultType rt2 = ResultTypeFactory.getResultType(xmlFileName);
        assertSame("2", rt, rt2);
    }
        
    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(ResultTypeFactoryTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{ResultTypeFactoryTest.class.getName()});
    }
}