package test.org.seasar.nazuna;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.BetweenExp;
import org.seasar.nazuna.BooleanExpression;
import org.seasar.nazuna.Expression;
import org.seasar.nazuna.IntegerExp;
import org.seasar.nazuna.NullExp;

public class BetweenExpTest extends TestCase {

    public BetweenExpTest(String name) {
        super(name);
    }

    public void testEvaluate() throws Exception {
        IntegerExp arg1Exp = new IntegerExp(new Integer(5));
        IntegerExp fromExp = new IntegerExp(new Integer(1));
        IntegerExp toExp = new IntegerExp(new Integer(10));
        BooleanExpression exp = new BetweenExp(arg1Exp, fromExp, toExp);
        assertEquals("1", true, exp.evaluate(null));
    }
    
    public void testEvaluate2() throws Exception {
        IntegerExp arg1Exp = new IntegerExp(new Integer(1));
        IntegerExp fromExp = new IntegerExp(new Integer(1));
        IntegerExp toExp = new IntegerExp(new Integer(10));
        BooleanExpression exp = new BetweenExp(arg1Exp, fromExp, toExp);
        assertEquals("1", true, exp.evaluate(null));
    }
    
    public void testEvaluate3() throws Exception {
        IntegerExp arg1Exp = new IntegerExp(new Integer(10));
        IntegerExp fromExp = new IntegerExp(new Integer(1));
        IntegerExp toExp = new IntegerExp(new Integer(10));
        BooleanExpression exp = new BetweenExp(arg1Exp, fromExp, toExp);
        assertEquals("1", true, exp.evaluate(null));
    }
    
    public void testEvaluate4() throws Exception {
        IntegerExp arg1Exp = new IntegerExp(new Integer(0));
        IntegerExp fromExp = new IntegerExp(new Integer(1));
        IntegerExp toExp = new IntegerExp(new Integer(10));
        BooleanExpression exp = new BetweenExp(arg1Exp, fromExp, toExp);
        assertEquals("1", false, exp.evaluate(null));
    }
    
    public void testEvaluate5() throws Exception {
        IntegerExp arg1Exp = new IntegerExp(new Integer(11));
        IntegerExp fromExp = new IntegerExp(new Integer(1));
        IntegerExp toExp = new IntegerExp(new Integer(10));
        BooleanExpression exp = new BetweenExp(arg1Exp, fromExp, toExp);
        assertEquals("1", false, exp.evaluate(null));
    }
    
    public void testEvaluate6() throws Exception {
        IntegerExp arg1Exp = new IntegerExp(new Integer(1));
        Expression fromExp = new NullExp();
        IntegerExp toExp = new IntegerExp(new Integer(10));
        BooleanExpression exp = new BetweenExp(arg1Exp, fromExp, toExp);
        assertEquals("1", false, exp.evaluate(null));
    }
    
    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(BetweenExpTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{BetweenExpTest.class.getName()});
    }
}