package org.seasar.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public final class NetUtil {

	private NetUtil() {
	}

  	public static String getHostName() {
    	try {
      		return InetAddress.getLocalHost().getHostName();
    	} catch (UnknownHostException ignore) {
      		return "localhost";
    	}
  	}

  	public static String getHostAddress() {
    	try {
      		return InetAddress.getLocalHost().getHostAddress();
    	} catch (UnknownHostException ignore) {
      		return "127.0.0.1";
    	}
  	}
  	
  	public static InetAddress[] getAllLocalInetAddress() {
		ArrayList addresses = new ArrayList();
		Enumeration e = null;
		try {
			e = NetworkInterface.getNetworkInterfaces();
		} catch (SocketException ex) {
			return new InetAddress[0];
		}
		while(e.hasMoreElements()) {
			NetworkInterface ni = (NetworkInterface) e.nextElement();
			for(Enumeration e2 = ni.getInetAddresses(); e2.hasMoreElements(); ) {
				addresses.add(e2.nextElement());
			}	
		}
		return (InetAddress[]) addresses.toArray(ArrayUtil.EMPTY_INETADDRESSES);
	}

	public static String[] getAllHostName() {
		Set hostNames = new HashSet();
		InetAddress[] addresses = getAllLocalInetAddress();
		for (int i = 0; i < addresses.length; ++i) {
			hostNames.add(addresses[i].getHostName());
			hostNames.add(addresses[i].getCanonicalHostName());
			hostNames.add(addresses[i].getHostAddress());
		}
		hostNames.add(getHostName());
		hostNames.add("localhost");
		return (String[]) hostNames.toArray(ArrayUtil.EMPTY_STRINGS);
	}
}