package org.seasar.nazuna;

import java.util.List;

import org.seasar.util.Assertion;
import org.seasar.util.EArrayList;
import org.seasar.util.SeasarException;
import org.seasar.util.Sorter;

public final class SortDesc {
	
	private Sorter _sorter;

    public SortDesc(String clause) throws SeasarException {
    	Assertion.assertNotNull("clause", clause);
    	
    	List sortElementList = new EArrayList();
    	RuleTokenizer tokenizer = new RuleTokenizer(clause);
    	int token = tokenizer.nextToken();
    	while (token != RuleTokenizer.EOF) {
    		String propertyName = tokenizer.getString();
    		token = tokenizer.nextToken();
    		SortType sortType = SortType.ASC;
    		switch (token) {
    			case RuleTokenizer.ASC:
    				tokenizer.nextToken();
    				sortType = SortType.ASC;
    				break;
    			case RuleTokenizer.DESC:
    				tokenizer.nextToken();
    				sortType = SortType.DESC;
    				break;
    		}
    		sortElementList.add(new SortElement(propertyName, sortType));
    		token = tokenizer.nextToken();
    		if (token == RuleTokenizer.COMMA) {
    			token = tokenizer.nextToken();
    		}
    	}
    	_sorter = new Calculator(
    		(SortElement[]) sortElementList.toArray(
    		new SortElement[sortElementList.size()]));
    }
    
    public SortDesc(SortElement[] sortElements) {
    	Assertion.assertNotNull("sortElements", sortElements);
    	
    	_sorter = new Calculator(sortElements);
    }

    public List sort(List items) {
        Assertion.assertNotNull("items", items);
        Object[] array = items.toArray();
        _sorter.sort(array);
        return new EArrayList(array);
    }
    
    private class Calculator extends Sorter {
    	
    	private SortElement[] _sortElements;
    	
    	Calculator(SortElement[] sortElements) {
    		_sortElements = sortElements;
    	}
    	
    	protected int doCompare(final Object o1, final Object o2) {
	        for (int i = 0; i < _sortElements.length; ++i) {
	            SortElement sortElement = (SortElement) _sortElements[i];
	            int result = sortElement.compare(o1, o2);
	            if (result != 0) {
	                return result;
	            }
	        }
	        return 0;
	    }
    }
}
