package org.seasar.nazuna;

import java.util.Map;

import org.seasar.util.SMap;

public final class ResultTypeFactory {

    private static final int INITIAL_CAPACITY = 89;
    private static Map _resultTypes = new SMap(INITIAL_CAPACITY);

    private ResultTypeFactory() { }

    public static ResultType getResultType(final String xmlFileName) {
        ResultType resultType = (ResultType) _resultTypes.get(xmlFileName);
        if (resultType != null) {
        	return resultType;
        }
        synchronized (_resultTypes) {
        	resultType = (ResultType) _resultTypes.get(xmlFileName);
            if (resultType == null) {
                resultType = ResultTypeBuilder.parse(xmlFileName);
                _resultTypes.put(xmlFileName, resultType);
            }    
        }
        return resultType;
    }
}