package org.seasar.nazuna;

import java.util.Map;

import org.seasar.util.Assertion;
import org.seasar.util.EMap;
import org.seasar.util.SMap;
import org.seasar.util.SeasarException;

public final class LocalType {

	private EMap _varTypes = new EMap();
	
	public LocalType() {
	}

	public void addVarType(VarType varType) {
		Assertion.assertNotNull("varType", varType);
		
		String name = varType.getName();
		Assertion.assertNotExist(name, _varTypes.put(name, varType));
	}
	
	public VarType getVarType(String name) {
		return (VarType) _varTypes.get(name);
	}
	
	public Map createVars() throws SeasarException {
		Map vars = new SMap();
		for (int i = 0; i < _varTypes.size(); ++i) {
			VarType varType = (VarType) _varTypes.get(i);
			Var var = new Var(varType);
			vars.put(varType.getName(), var);
		}
		return vars;
	}
}
