package org.seasar.naming;

import java.io.Serializable;
import java.util.Map;

import javax.naming.Name;
import javax.naming.NamingException;

public class NamingServerWrapper implements NamingServerMBean, Serializable {

	final static long serialVersionUID = 1L;
	
	private NamingServerMBean _namingServer;
	
	public NamingServerWrapper(NamingServerMBean namingServer) {
		_namingServer = namingServer;
	}

	public void bind(Name name, Object obj) throws NamingException {
		try {
			_namingServer.bind(name, obj);
		} catch (Throwable t) {
			throw NamingUtil.convertNamingException(t);
		}
	}

	public void rebind(Name name, Object obj) throws NamingException {
		try {
			_namingServer.rebind(name, obj);
		} catch (Throwable t) {
			throw NamingUtil.convertNamingException(t);
		}
	}

	public void unbind(Name name) throws NamingException {
		try {
			_namingServer.unbind(name);
		} catch (Throwable t) {
			throw NamingUtil.convertNamingException(t);
		}
	}

	public Object lookup(Name name) throws NamingException {
		try {
			return _namingServer.lookup(name);
		} catch (Throwable t) {
			throw NamingUtil.convertNamingException(t);
		}
	}

	public Map getNameMap(Name name) throws NamingException {
		try {
			return _namingServer.getNameMap(name);
		} catch (Throwable t) {
			throw NamingUtil.convertNamingException(t);
		}
	}

	public NamingContext createSubcontext(Name name) throws NamingException {
		try {
			return _namingServer.createSubcontext(name);
		} catch (Throwable t) {
			throw NamingUtil.convertNamingException(t);
		}
	}

	public void destroySubcontext(Name name) throws NamingException {
		try {
			_namingServer.destroySubcontext(name);
		} catch (Throwable t) {
			throw NamingUtil.convertNamingException(t);
		}
	}
}
