package org.seasar.naming;

import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.NamingException;

import org.seasar.message.MessageFormatter;
import org.seasar.system.MBeanProxy;
import org.seasar.util.SeasarException;

public final class NamingServerManager {

    private NamingServerManager() { }

    public static NamingServerMBean getNamingServer(final Hashtable env) throws NamingException {
    	if (env == null) {
    		if (NamingService.isSameVM()) {
    			return NamingService.getNamingServer();
    		} else {
    			throw new NamingException(
            		MessageFormatter.getMessage("ESSR0007", new Object[]{"env"}));
    		}
    	}
        String url = (String) env.get(Context.PROVIDER_URL);
        if (url != null && url.length() > 0) {
            try {
            	return new NamingServerWrapper((NamingServerMBean) MBeanProxy.create(NamingServerMBean.class,
                	NamingServerMBean.NAME, url));
            } catch (SeasarException ex) {
            	throw NamingUtil.convertNamingException(ex);
            }
        } else {
        	if (NamingService.isSameVM()) {
    			return NamingService.getNamingServer();
    		} else {
    			throw new NamingException(
	            	MessageFormatter.getMessage("ESSR0001", new Object[]{Context.PROVIDER_URL}));
    		}
            
        }
    }
}
