package org.seasar.naming;

import java.util.Map;

import javax.naming.Name;
import javax.naming.NamingException;

import org.seasar.system.JMXUtil;

public interface NamingServerMBean {

	public String NAME = JMXUtil.getMBeanName("NamingServer");
	
  	public void bind(final Name name, final Object obj) throws NamingException;

  	public void rebind(final Name name, final Object obj) throws NamingException;

 	public void unbind(final Name name) throws NamingException;

	public Object lookup(final Name name) throws NamingException;

	public Map getNameMap(final Name name) throws NamingException;

	public NamingContext createSubcontext(final Name name) throws NamingException;

	public void destroySubcontext(final Name name) throws NamingException;
}