package org.seasar.eclipse.editors;

import java.io.IOException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.seasar.eclipse.FileUtil;
import org.seasar.eclipse.SeasarPlugin;

public final class PropertiesFileDocumentProvider extends FileDocumentProvider {

	public PropertiesFileDocumentProvider() {
	}

    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput,
            String encoding) throws CoreException {

        if (editorInput instanceof IFileEditorInput) {
            try {
                IFile file = ((IFileEditorInput) editorInput).getFile();
                String s = FileUtil.convertAsciiToNative(file.getContents(false));
                document.set(s);
                return true;
            } catch (IOException ex) {
                SeasarPlugin.handleException(ex);
            }
        }
		return super.setDocumentContent(document, editorInput, encoding);
	}

    protected void doSaveDocument(IProgressMonitor monitor, Object element,
            IDocument document, boolean overwrite) throws CoreException {
                
        try {
            String nativeStr = document.get();
            String asciiStr = FileUtil.convertNativeToAscii(nativeStr);
            super.doSaveDocument(monitor, element, new Document(asciiStr), overwrite);
        } catch (IOException ex) {
            SeasarPlugin.handleException(ex);
        }
	}

}


