package examples.org.seasar;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class ConnectionPoolExample {

	private static final String FACTORY =
		"org.seasar.naming.NamingContextFactory";
	private static final String URL = "localhost:1108";
	private static final String JNDI_NAME = "jdbc/hsqldb";
	private static final String SQL = "SELECT ename FROM emp";
	
	public static void main(String[] args) {
		try {
			Properties env = new Properties();
			env.put(Context.INITIAL_CONTEXT_FACTORY, FACTORY);
			env.put(Context.PROVIDER_URL, URL);
			InitialContext ctx = new InitialContext(env);
			DataSource ds = (DataSource) ctx.lookup(JNDI_NAME);
			Connection con = null;
			Statement stmt = null;
			ResultSet rs = null;
			try {
				con = ds.getConnection();
				stmt = con.createStatement();
				rs = stmt.executeQuery(SQL);
				while (rs.next()) {
					System.out.println(rs.getString("ename"));
				}
			} finally {
				if (rs != null) {
					rs.close();
				}
				if (stmt != null) {
					stmt.close();
				}
				if (con != null) {
					con.close();
				}
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}
}
