package test.org.seasar.util;

import junit.framework.*;
import java.math.*;
import org.seasar.util.*;

public class MathUtilTest extends TestCase {

    public MathUtilTest(String name) {
        super(name);
    }

    public void testAdd() throws Exception {
        assertEquals("1", new Integer(3), MathUtil.add(new Integer(1), new Integer(2)));
        assertEquals("2", new Long(12345678902L),
        	MathUtil.add(new Integer(1), new Long(12345678901L)));
        assertEquals("3", new Double(2),
        	MathUtil.add(new Integer(1), new Double(1)));
        assertEquals("4", new Long(60000000000L), MathUtil.add(new Long(30000000000L), new Long(30000000000L)));
        assertEquals("5", new Long(30000000002L), MathUtil.add(new Long(30000000000L), new Integer(2)));
        assertEquals("6", new Double(30000000002L), MathUtil.add(new Long(30000000000L), new Double(2)));
        assertEquals("7", new Double(3), MathUtil.add(new Double(1), new Double(2)));
        assertEquals("8", new Double(3), MathUtil.add(new Double(1), new Integer(2)));
        assertEquals("9", new Double(30000000001L), MathUtil.add(new Double(1), new Long(30000000000L)));
        assertEquals("10", null, MathUtil.add(null, new Integer(2)));
        try {
        	MathUtil.add(new Short((short)1), new Long(2));
        	fail("11");
        } catch (SeasarRuntimeException ex) {
        	System.out.println(ex);
        }
    }
    
    public void testSubtract() throws Exception {
        assertEquals("1", new Integer(-1),
        	MathUtil.subtract(new Integer(1), new Integer(2)));
        assertEquals("2", new Long(12345678900L),
        	MathUtil.subtract(new Long(12345678901L), new Integer(1)));
        assertEquals("3", new Double(2),
        	MathUtil.subtract(new Integer(3), new Double(1)));
        assertEquals("4", new Long(1),
        	MathUtil.subtract(new Long(30000000001L), new Long(30000000000L)));
        assertEquals("5", new Long(30000000000L),
        	MathUtil.subtract(new Long(30000000001L), new Integer(1)));
        assertEquals("6", new Double(30000000000L),
        	MathUtil.subtract(new Long(30000000001L), new Double(1)));
        assertEquals("7", new Double(1),
        	MathUtil.subtract(new Double(3), new Double(2)));
        assertEquals("8", new Double(-1),
        	MathUtil.subtract(new Double(1), new Integer(2)));
        assertEquals("9", new Double(1),
        	MathUtil.subtract(new Double(30000000001L), new Long(30000000000L)));
        assertEquals("10", null, MathUtil.subtract(null, new Integer(2)));
        try {
        	MathUtil.subtract(new Short((short)1), new Long(2));
        	fail("11");
        } catch (SeasarRuntimeException ex) {
        	System.out.println(ex);
        }
    }
    
    public void testMultiply() throws Exception {
        assertEquals("1", new Integer(6),
        	MathUtil.multiply(new Integer(2), new Integer(3)));
        assertEquals("2", new Long(60000000000L),
        	MathUtil.multiply(new Long(30000000000L), new Integer(2)));
        assertEquals("3", new Double(6),
        	MathUtil.multiply(new Integer(3), new Double(2)));
        assertEquals("4", new Long(6000000000L),
        	MathUtil.multiply(new Long(3000000000L), new Long(2)));
        assertEquals("5", new Long(6000000000L),
        	MathUtil.multiply(new Long(2), new Long(3000000000L)));
        assertEquals("6", new Long(30000000000L),
        	MathUtil.multiply(new Long(30000000000L), new Integer(1)));
        assertEquals("7", new Double(30000000000L),
        	MathUtil.multiply(new Long(30000000000L), new Double(1)));
        assertEquals("8", new Double(6),
        	MathUtil.multiply(new Double(3), new Double(2)));
        assertEquals("9", new Double(6),
        	MathUtil.multiply(new Double(3), new Integer(2)));
        assertEquals("10", new Double(30000000000L),
        	MathUtil.multiply(new Double(1), new Long(30000000000L)));
        assertEquals("11", null, MathUtil.multiply(null, new Integer(2)));
        try {
        	MathUtil.multiply(new Short((short)1), new Long(2));
        	fail("12");
        } catch (SeasarRuntimeException ex) {
        	System.out.println(ex);
        }
    }

    public void testDivide() throws Exception {
        assertEquals("1", new Integer(1),
        	MathUtil.divide(new Integer(3), new Integer(2)));
        assertEquals("2", new Integer(3),
        	MathUtil.divide(new Integer(6), new Integer(2)));
        assertEquals("3", new Long(30000000000L),
        	MathUtil.divide(new Long(60000000000L), new Integer(2)));
        assertEquals("4", new Double(3),
        	MathUtil.divide(new Integer(6), new Double(2)));
        assertEquals("5", new Double(2.5),
        	MathUtil.divide(new Integer(5), new Double(2)));
        assertEquals("6", new Long(2),
        	MathUtil.divide(new Long(6000000000L), new Long(3000000000L)));
        assertEquals("7", new Long(30000000000L),
        	MathUtil.divide(new Long(30000000000L), new Integer(1)));
        assertEquals("8", new Double(30000000000L),
        	MathUtil.divide(new Long(30000000000L), new Double(1)));
        assertEquals("9", new Double(1.5),
        	MathUtil.divide(new Double(3), new Double(2)));
        assertEquals("10", new Double(1.5),
        	MathUtil.divide(new Double(3), new Integer(2)));
        assertEquals("11", new Double(1),
        	MathUtil.divide(new Double(30000000000L), new Long(30000000000L)));
        assertEquals("12", null, MathUtil.divide(null, new Integer(2)));
        try {
        	MathUtil.divide(new Short((short)1), new Long(2));
        	fail("13");
        } catch (SeasarRuntimeException ex) {
        	System.out.println(ex);
        }
    }
    
    public void testMod() throws Exception {
        assertEquals("1", new Integer(1), MathUtil.mod(new Integer(5), new Integer(2)));
        assertEquals("2", new Long(1), MathUtil.mod(new Long(5), new Long(2)));
        assertEquals("3", new Double(1), MathUtil.mod(new Double(5), new Double(2)));
        assertEquals("4", null, MathUtil.mod(null, new Integer(2)));
        assertEquals("5", new Long(1), MathUtil.mod(new Integer(1), new Long(2)));
    }
    
    public void testAbs() throws Exception {
        assertEquals("1", new Integer(1), MathUtil.abs(new Integer(1)));
        assertEquals("2", new Integer(1), MathUtil.abs(new Integer(-1)));
        assertEquals("3", new Long(1), MathUtil.abs(new Long(1)));
        assertEquals("4", new Long(1), MathUtil.abs(new Long(-1)));
        assertEquals("5", new BigDecimal(1), MathUtil.abs(new BigDecimal(1)));
        assertEquals("6", new BigDecimal(1), MathUtil.abs(new BigDecimal(-1)));
        assertEquals("7", null, MathUtil.abs((Number) null));
    }
    
    public void testTrunc() throws Exception {
        assertEquals("1", new BigDecimal(42), MathUtil.trunc(new BigDecimal(42.8)));
        assertEquals("2", new BigDecimal(-42), MathUtil.trunc(new BigDecimal(-42.8)));
    }
    
    public void testMax() throws Exception {
        String s1 = "a";
        String s2 = "b";
        assertEquals("1", s2, MathUtil.max(s1, s2));
        assertEquals("2", s2, MathUtil.max(null, s2));
        assertEquals("3", s1, MathUtil.max(s1, null));
    }

    public void testMin() throws Exception {
        String s1 = "a";
        String s2 = "b";
        assertEquals("1", s1, MathUtil.min(s1, s2));
        assertEquals("2", s2, MathUtil.min(null, s2));
        assertEquals("3", s1, MathUtil.min(s1, null));
    }

	public void testSum() throws Exception {
        assertEquals("1", new BigDecimal(3), MathUtil.sum(new BigDecimal(1), new BigDecimal(2)));
        assertEquals("2", new BigDecimal(1), MathUtil.sum(new BigDecimal(1), null));
        assertEquals("3", new BigDecimal(2), MathUtil.sum(null, new BigDecimal(2)));
        assertEquals("4", new BigDecimal(0), MathUtil.sum(null, null));
    }

    protected void setUp() throws Exception {
    }


    protected void tearDown() throws Exception {
    }


    public static Test suite() {
        return new TestSuite(MathUtilTest.class);
    }



    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{MathUtilTest.class.getName()});
    }
}
