package test.org.seasar.util;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.util.Like;

public class LikeTest extends TestCase {

    public LikeTest(String name) {
        super(name);
    }

	public void testMatch() throws Exception {
		assertEquals("1", true, Like.match("SCOTT", "SCOTT"));
		assertEquals("2", true, Like.match("_COT_", "SCOTT"));
		assertEquals("3", true, Like.match("SC%", "SCOTT"));
		assertEquals("4", true, Like.match("SC%T", "SCOTT"));
		assertEquals("5", true, Like.match("%TT", "SCOTT"));
		assertEquals("6", true, Like.match("S_O%T", "SCOTT"));
		assertEquals("7", false, Like.match("COTT", "SCOTT"));
		assertEquals("8", false, Like.match("_COT", "SCOTT"));
		assertEquals("9", false, Like.match("SC%A", "SCOTT"));
		assertEquals("10", false, Like.match("%OT", "SCOTT"));
		assertEquals("11", true, Like.match("SCOTT%", "SCOTT"));
		assertEquals("12", false, Like.match("SCOTT_", "SCOTT"));
		assertEquals("13", true, Like.match("%SCOTT", "SCOTT"));
		assertEquals("14", true, Like.match("%SCOTT%", "SCOTT"));
		assertEquals("15", true, Like.match("S%", "SCOTT"));
		assertEquals("16", true, Like.match("%abc%abc", "xxxabcyyyabc"));
	}

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(LikeTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{LikeTest.class.getName()});
    }
}