package test.org.seasar.system;

import javax.management.ObjectName;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.seasar.system.JMXService;
import org.seasar.system.JMXUtil;
import org.seasar.system.MBeanProxy;

public class JMXUtilTest extends RMIAdaptorTestCase {

    public JMXUtilTest(String name) {
        super(name);
    }

    public void testGetObjectName() throws Exception {
    	ObjectName oname = JMXUtil.getObjectName("DefaultDomain:type=test");
        assertNotNull("1", oname);
        assertEquals("2", oname, JMXUtil.getObjectName("DefaultDomain:type=test"));
        try {
            JMXUtil.getObjectName("hoge");
            fail("3");
        } catch (Exception ex) {
            System.out.println(ex);
        }
    }
    
    public void testGetMBeanInterface() throws Exception {
        assertEquals("1", HelloMBean.class, JMXUtil.getMBeanInterface(Hello2.class));

		Hello hello = new Hello();
		JMXService.registerMBean(hello, HelloMBean.NAME);        
        Object proxy = MBeanProxy.create(HelloMBean.class, HelloMBean.NAME);
        assertEquals("2", HelloMBean.class, JMXUtil.getMBeanInterface(proxy.getClass()));
    }

    protected void setUp() throws Exception {
    	super.setUp();
    }


    protected void tearDown() throws Exception {
    	super.tearDown();
    }


    public static Test suite() {
        return new TestSuite(JMXUtilTest.class);
    }



    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{JMXUtilTest.class.getName()});
    }
}
