package test.org.seasar.nazuna;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.Expression;
import org.seasar.nazuna.StringExp;
import org.seasar.nazuna.ToTimestampExp;

public class ToTimestampExpTest extends TestCase {

    public ToTimestampExpTest(String name) {
        super(name);
    }

    public void testEvaluate() throws Exception {
    	Expression exp = new ToTimestampExp(new StringExp("20021114"), "yyyyMMdd");
    	Timestamp t = new Timestamp(new SimpleDateFormat("yyyyMMdd").parse("20021114").getTime());
        assertEquals("1", t, exp.evaluateValue(null));
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(ToTimestampExpTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{ToTimestampExpTest.class.getName()});
    }
}