package test.org.seasar.mbean;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.seasar.mbean.NotificationListenerFacade;
import org.seasar.system.JMXService;
import org.seasar.util.SeasarException;

import test.org.seasar.system.NotificationListenerTester;
import test.org.seasar.system.Notify;
import test.org.seasar.system.NotifyMBean;
import test.org.seasar.system.RMIAdaptorTestCase;

public class NotificationListenerFacadeTest extends RMIAdaptorTestCase {

	private NotificationListenerFacade _listenerFacade;
	
    public NotificationListenerFacadeTest(String name) throws Exception {
        super(name);
    }

	public void testStartAndStop() throws Exception {
		Notify notify = new Notify();
		JMXService.registerMBean(notify, NotifyMBean.NAME);
		
		_listenerFacade = new NotificationListenerFacade(
			NotificationListenerTester.class.getName(), "Notify");
		NotificationListenerTester listener = null;
    	_listenerFacade.start();
    	try {
   			listener = (NotificationListenerTester)
    			_listenerFacade.getNotificationListener();
    		assertNotNull("1", listener);
    		assertEquals("2", true, listener.isStarted());
			notify.sendMessage("Hello");
			assertEquals("3", true, listener.isCalled());
    	} finally {
    		_listenerFacade.stop();
    	}
    	try {
    		JMXService.removeNotificationListener(NotifyMBean.NAME, listener);
    		fail("4");
    	} catch (SeasarException ex) {
    		System.out.println(ex);
    	}
	}

    protected void setUp() throws Exception {
    	super.setUp();    	
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public static Test suite() {
        return new TestSuite(NotificationListenerFacadeTest.class);
    }

    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{NotificationListenerFacadeTest.class.getName()});
    }
}