package org.seasar.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.IOException;
import java.net.URL;

import javax.xml.parsers.SAXParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLHandlerParser {

    private XMLHandlerParser() { }

    public static Object parse(final String path, final XMLHandlerRule rule) {
        return parse(path, rule, null);
    }

    public static Object parse(final String path, final XMLHandlerRule rule,
    		final boolean usePathMatching) {
    			
        return parse(path, rule, null, usePathMatching);
    }
  
    public static Object parse(final String path, final XMLHandlerRule rule,
  	    final Object result) {
  	    	
        return parse(path, rule, result, true);
    }

    public static Object parse(final String path, final XMLHandlerRule rule,
  	    final Object result, final boolean usePathMatching) {
  	    	
        return parse(ResourceUtil.getResourceAsStream(path, "xml"),
        	rule, result, usePathMatching);
    }

    public static Object parse(final URL url, final XMLHandlerRule rule) {
        return parse(url, rule, null);
    }

    public static Object parse(final URL url, final XMLHandlerRule rule,
    		final boolean usePathMatching) {
    			
        return parse(url, rule, null, usePathMatching);
    }
  
    public static Object parse(final URL url, final XMLHandlerRule rule,
  	    final Object result) {
  	    	
        return parse(url, rule, result, true);
    }
    
    public static Object parse(final URL url, final XMLHandlerRule rule,
  	    final Object result, final boolean usePathMatching) {
  	    	
  	    try {
        	return parse(url.openStream(), rule, result, usePathMatching);
  	    } catch (IOException ex) {
  	    	throw SeasarRuntimeException.convertSeasarRuntimeException(ex);
  	    }
    }
    
    public static Object parse(final File file, final XMLHandlerRule rule) {
        return parse(file, rule, null);
    }

    public static Object parse(final File file, final XMLHandlerRule rule,
    		final boolean usePathMatching) {
    			
        return parse(file, rule, null, usePathMatching);
    }
    
    public static Object parse(final File file, final XMLHandlerRule rule,
  	    final Object result) {
  	    	
        return parse(file, rule, result, true);
    }
    
    public static Object parse(final File file, final XMLHandlerRule rule,
  	    final Object result, final boolean usePathMatching) {
  	    	
  	    try {
        	return parse(new BufferedInputStream(new FileInputStream(file)), rule, result, usePathMatching);
  	    } catch (IOException ex) {
  	    	throw SeasarRuntimeException.convertSeasarRuntimeException(ex);
  	    }
    }

    public static Object parse(final InputStream inputStream, final XMLHandlerRule rule) {
        return parse(inputStream, rule, null);
    }

    public static Object parse(final InputStream inputStream, final XMLHandlerRule rule,
  	    final Object result) {
    
        return parse(inputStream, rule, result, true);
    }

    public static Object parse(final InputStream inputStream, final XMLHandlerRule rule,
  	    final Object result, final boolean usePathMatching) {
    
        return parse(new InputSource(inputStream), rule, result, usePathMatching);
    }

    public static Object parse(final InputSource inputSource, final XMLHandlerRule rule) {
        return parse(inputSource, rule, null);
    }

    public static Object parse(final InputSource inputSource, final XMLHandlerRule rule,
  	    final Object result) {
        
        return parse(inputSource, rule, result, true);
    }

    public static Object parse(final InputSource inputSource, final XMLHandlerRule rule,
  	    final Object result, final boolean usePathMatching) {
        
        SAXParser saxParser = XMLUtil.getSAXParser();
        XMLHandler xmlHandler = new XMLHandler(rule, usePathMatching);
        if (result != null) {
    	    xmlHandler.push(result);
        }
        try {
            saxParser.parse(inputSource, xmlHandler);
        } catch (SAXException ex) {
        	Exception e = ex.getException();
        	if (e instanceof RuntimeException) {
        		throw (RuntimeException) e;
        	}
        	Throwable t = ex.getCause();
        	if (t instanceof RuntimeException) {
        		throw (RuntimeException) t;
        	} else {
            	throw SeasarRuntimeException.convertSeasarRuntimeException(ex);
        	}
        } catch (IOException ex) {
            throw SeasarRuntimeException.convertSeasarRuntimeException(ex);
        }
        return xmlHandler.getResult();
    }
}
