package org.seasar.util;

import java.util.*;

public final class EArrayStack extends EArrayList {

	static final long serialVersionUID = -2700027602421363408L;

	public EArrayStack() {
	}

	public boolean empty() {
		return size() == 0;
	}

	public Object push(Object item) {
		add(item);
		return item;
	}

	public Object pop() {
		if (empty()) {
			throw new EmptyStackException();
		}
		return remove(size() - 1);
	}

	public Object peek() {
		return peek(0);
	}

	public Object peek(int n) {
		int m = size() - n - 1;
		if (m < 0) {
			throw new EmptyStackException();
		} else {
			return get(m);
		}
	}

	public int search(Object o) {
		int i = lastIndexOf(o);
		if (i >= 0) {
			return size() - i;
		} else {
			return -1;
		}
	}
}