package org.seasar.util;

public final class Assertion {

	private Assertion() {
	}

	public static final void assertNotNull(String name, Object value) {
		assertTrue(value != null, "ESSR0007", name);
	}

	public static final void assertFound(String name, Object value) {
		assertTrue(value != null, "ESSR0001", name, value);
	}
	
	public static final void assertNotExist(String name, Object value) {
		assertTrue(value == null, "ESSR0018", name);
	}
	
	public static final void assertEquals(String name, Object expected,
			Object actual) {
				
		assertTrue(expected == null ? actual == null : expected.equals(actual),
			"ESSR0002", name, expected, actual);
	}
	
	public static final void assertEquals(String name, long expected,
			long actual) {
				
		assertTrue(expected == actual,
			"ESSR0002", name, Long.toString(expected), Long.toString(actual));
	}
	
	public static final void assertTrue(boolean condition, String messageCode,
			Object arg0) {
				
		assertTrue(condition, messageCode, new Object[]{arg0});
	}
	
	public static final void assertTrue(boolean condition, String messageCode,
			Object arg0, Object arg1) {
				
		assertTrue(condition, messageCode, new Object[]{arg0, arg1});
	}
	
	public static final void assertTrue(boolean condition, String messageCode,
			Object arg0, Object arg1, Object arg2) {
				
		assertTrue(condition, messageCode, new Object[]{arg0, arg1, arg2});
	}
	
	public static final void assertTrue(boolean condition, String messageCode,
			Object arg0, Object arg1, Object arg2, Object arg3) {
				
		assertTrue(condition, messageCode, new Object[]{arg0, arg1, arg2, arg3});
	}
	
	public static final void assertTrue(boolean condition, String messageCode,
			Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
				
		assertTrue(condition, messageCode, new Object[]{arg0, arg1, arg2, arg3, arg4});
	}
				
	public static final void assertTrue(boolean condition, String messageCode,
			Object[] args) {
				
		if (!condition) {
			throw new SeasarRuntimeException(messageCode, args, Assertion.class);
		}
	}
	
	public static final void assertFalse(boolean condition, String messageCode,
			Object arg0) {
				
		assertFalse(condition, messageCode, new Object[]{arg0});
	}
	
	public static final void assertFalse(boolean condition, String messageCode,
			Object arg0, Object arg1) {
				
		assertFalse(condition, messageCode, new Object[]{arg0, arg1});
	}
	
	public static final void assertFalse(boolean condition, String messageCode,
			Object arg0, Object arg1, Object arg2) {
				
		assertFalse(condition, messageCode, new Object[]{arg0, arg1, arg2});
	}
	
	public static final void assertFalse(boolean condition, String messageCode,
			Object arg0, Object arg1, Object arg2, Object arg3) {
				
		assertFalse(condition, messageCode, new Object[]{arg0, arg1, arg2, arg3});
	}
	
	public static final void assertFalse(boolean condition, String messageCode,
			Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
				
		assertFalse(condition, messageCode, new Object[]{arg0, arg1, arg2, arg3, arg4});
	}
				
	public static final void assertFalse(boolean condition, String messageCode,
			Object[] args) {
				
		if (condition) {
			throw new SeasarRuntimeException(messageCode, args, Assertion.class);
		}
	}
}
