package org.seasar.transaction;

import java.util.ArrayList;
import java.util.List;

import javax.transaction.RollbackException;
import javax.transaction.Status;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;

public final class XAResourceManager {

    private static XAResourceManager _instance = new XAResourceManager();
    private ThreadLocal _threadXAResourceList = new ThreadLocal();

    private XAResourceManager() { }

    public static XAResourceManager getInstance() {
        return _instance;
    }

    public void addXAResource(final XAResource xaResource) throws SystemException, RollbackException {
        Transaction tx = TransactionManagerImpl.getInstance().getTransaction();
        if (tx != null && tx.getStatus() == Status.STATUS_ACTIVE) {
            tx.enlistResource(xaResource);
            return;
        }
        List list = getXAResourceList();
        if (list == null) {
            list = new ArrayList();
            _threadXAResourceList.set(list);
        }
        list.add(xaResource);
    }

    public void removeXAResource(final XAResource xaResource) {
        List list = getXAResourceList();
        if (list == null) {
            return;
        }
        list.remove(xaResource);
    }

    public List getXAResourceList() {
        return (List) _threadXAResourceList.get();
    }

    public int getXAResourceCount() {
        List list = getXAResourceList();
        if (list == null) {
            return 0;
        }
        return list.size();
    }
}