package org.seasar.nazuna.amf;

import java.util.List;

import org.seasar.util.EArrayList;

public final class AMFMessage {

	private List _bodies = new EArrayList();

	public AMFMessage() {
	}

	public void addBody(String target, String response, Object value) {
		addBody(new AMFBody(target, response, value));
	}

	public void addBody(AMFBody body) {
		_bodies.add(body);
	}

	public int getBodyCount() {
		return _bodies.size();
	}

	public AMFBody getBody(int index) {
		return (AMFBody) _bodies.get(index);
	}
}