package org.seasar.nazuna;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class OutputType {

	private Class _outputClass;
	
	public OutputType(Class outputClass) {
		Assertion.assertNotNull("outputClass", outputClass);
		
		_outputClass = outputClass;
	}

	public Class getOutputClass() {
		return _outputClass;
	}
	
	public void validate(Object value) throws SeasarException {
		if (value != null && !_outputClass.isInstance(value)) {
			throw new SeasarException("ESSR0002",
				new Object[]{"output", _outputClass.getName(), value.getClass().getName()});
		}
	}
}
