package org.seasar.nazuna;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.seasar.util.Reflector;
import org.seasar.util.SMap;
import org.seasar.util.SeasarException;

public final class MapResultType extends ResultType {

	public MapResultType(Class resultClass) {
		super(resultClass);
	}

	public static ResultType create(ResultSetMetaData rsMeta)
		throws SQLException {

		MapResultType ret = new MapResultType(SMap.class);
		final int columnCount = rsMeta.getColumnCount();
		for (int i = 1; i <= columnCount; ++i) {
			String name = rsMeta.getColumnName(i);
			int type = rsMeta.getColumnType(i);
			ret.addPropertyType(name, name, type);
		}
		ret.addPropertyTypeDone();
		return ret;
	}

	public final List fetch(ResultSet rs) throws SeasarException {
		List results = new ArrayList();
		try {
			while (rs.next()) {
				Map map = (Map) Reflector.newInstance(_resultClass);
				for (int i = 0; i < _propertyTypes.length; ++i) {
					_propertyTypes[i].fetch(rs, map);
				}
				results.add(map);
			}
		} catch (SQLException ex) {
			throw SeasarException.convertSeasarException(ex);
		}
		return results;
	}

	public void addPropertyType(
		String propertyName,
		String columnName,
		String typeName) {

		ValueType valueType =
			typeName == null ? ValueType.STRING : ValueType.getType(typeName);
		addPropertyType(
			new MapPropertyType(propertyName, columnName, valueType));
	}

	public void addPropertyType(
		String propertyName,
		String columnName,
		int type) {

		ValueType valueType = ValueType.getType(type);
		addPropertyType(
			new MapPropertyType(propertyName, columnName, valueType));
	}
}
