package org.seasar.nazuna;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class IsFalseExp implements BooleanExpression {

    private final Expression _targetExp;

    public IsFalseExp(final Expression targetExp) {
    	Assertion.assertNotNull("targetExp", targetExp);

        _targetExp = targetExp;
    }

    public boolean evaluate(RuleContext ruleContext) throws SeasarException {
        Object target = _targetExp.evaluateValue(ruleContext);
        if (target instanceof Boolean) {
            return ((Boolean) target).equals(Boolean.FALSE);
        } else {
            return false;
        }
    }
}