package org.seasar.nazuna;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public class ForTag extends RuleStatementContainerImpl implements RuleStatementContainer, RuleStatement {

	public static final String DEFAULT_LABEL = "_DEFAULT_";
	private Expression[] _initExps;
	private BooleanExpression _conditionExp;
	private Expression[] _nextExps;
	private String _label;
	
	public ForTag(Object parent, String location,
			Expression[] initExps, BooleanExpression conditionExp,
			Expression[] nextExps, String label) {
				
		super(parent, location);
		Assertion.assertNotNull("conditionExp", conditionExp);
		
		_initExps = initExps;
		_conditionExp = conditionExp;
		_nextExps = nextExps;
		if (label == null) {
			_label = DEFAULT_LABEL;
		} else {
			_label = label;
		}
	}
	
	public final void execute(RuleContext ruleContext) throws SeasarException {
		try {
			for (processInit(ruleContext);
					_conditionExp.evaluate(ruleContext);
					processNext(ruleContext)) {
						
				for (int i = 0; i < _ruleStatements.length; ++i) {
					RuleStatement ruleStatement = _ruleStatements[i];
					ruleStatement.execute(ruleContext);
					if (ruleContext.isBreaked()) {
						if (ruleContext.isBreaked(_label)) {
							ruleContext.clearForState();
						}
						return;
					}
					if (ruleContext.isContinued()) {
						if (ruleContext.isContinued(_label)) {
							ruleContext.clearForState();
							break;
						} else {
							return;
						}
					}
					if (ruleContext.isReturned() || ruleContext.isThrowed()) {
						return;
					}
				}
			}
		} catch (Throwable t) {
			ruleContext.setThrowable(t, getLocation());
		}
	}
	
	private final void processInit(RuleContext ruleContext)
			throws SeasarException {
				
		for (int i = 0; i < _initExps.length; ++i) {
			_initExps[i].evaluateValue(ruleContext);
		}
	}
	
	private final void processNext(RuleContext ruleContext)
			throws SeasarException {
				
		for (int i = 0; i < _nextExps.length; ++i) {
			_nextExps[i].evaluateValue(ruleContext);
		}
	}
}
