package org.seasar.nazuna;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class DoubleExp implements Expression {

    private final Double _value;

    public DoubleExp(Double value) {
    	Assertion.assertNotNull("value", value);

        _value = value;
    }

    public Object evaluateValue(RuleContext ruleContext) throws SeasarException {
        return _value;
    }
}