package org.seasar.nazuna;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class CoalesceExp implements Expression {

    private final Expression[] _exps;

    public CoalesceExp(final Expression[] exps) {
    	Assertion.assertNotNull("exps", exps);

        _exps = exps;
    }


    public Object evaluateValue(RuleContext ruleContext) throws SeasarException {
        for (int i = 0; i < _exps.length; i++) {
            Object o = _exps[i].evaluateValue(ruleContext);
            if (o != null) {
                return o;
            }
        }
        return null;
    }
}
