package examples.org.seasar;

import java.sql.Connection;
import java.sql.Statement;
import java.util.Properties;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.transaction.UserTransaction;

public class TransactionExample {

	private static final String FACTORY =
		"org.seasar.naming.NamingContextFactory";
	private static final String URL = "localhost:1108";
	private static final String TX_JNDI_NAME = "java:comp/UserTransaction";
	private static final String DS_JNDI_NAME = "jdbc/hsqldb";
	private static final String SQL =
		"UPDATE emp SET ename='SCOTT' WHERE empno = 7788";
	
	public static void main(String[] args) {
		try {
			Properties env = new Properties();
			env.put(Context.INITIAL_CONTEXT_FACTORY, FACTORY);
			env.put(Context.PROVIDER_URL, URL);
			InitialContext ctx = new InitialContext(env);
			UserTransaction tx = (UserTransaction) ctx.lookup(TX_JNDI_NAME);
			DataSource ds = (DataSource) ctx.lookup(DS_JNDI_NAME);
			Connection con = null;
			Statement stmt = null;
			tx.begin();
			try {
				con = ds.getConnection();
				stmt = con.createStatement();
				int rows = stmt.executeUpdate(SQL);
				System.out.println("updated " + rows + " row(s)");
				tx.commit();
			} catch (Exception ex) {
				tx.rollback();
				ex.printStackTrace();
			} finally {
				if (stmt != null) {
					stmt.close();
				}
				if (con != null) {
					con.close();
				}
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}
}
