package com.jm;

import com.jm.utility.Resource;

import android.graphics.Color;

public class SiteswapWriter {

	private String[]	siteswap;
	private int[]		posX;
	private int			counter;

	public SiteswapWriter(SiteSwap siteswap)
	{
		this.siteswap = siteswap.getStrings();
		this.counter = -1;
		this.posX = new int[this.siteswap.length];
	}
	
	private void initialize(JugglerCanvas jc) {
		int l = 0;
		for(int i = 0; i < siteswap.length; i++) {
			posX[i] = l;
			l += siteswap[i].length();
		}
		int width = jc.getWidth() / l;
		if (width > Resource.charWidth()) width = Resource.charWidth();
		int x = -width * l / 2;
		for(counter = 0; counter < siteswap.length; counter++) {
			posX[counter] = posX[counter] * width + x;
			drawString(jc, Color.BLACK);
		}
		counter--;
	}

	/*********************************************************************
	 *********************************************************************/
	public void drawSiteswap(JugglerCanvas jc) {
		if (counter < 0) {
			initialize(jc);
		}
// edit {
//		drawString(jc);
		int counterBak = counter;
		for(int i = 0; i < siteswap.length; i++) {
			counter = i;
			drawString(jc, Color.BLACK);
		}
		counter = counterBak;
// }
		jc.setEmphasisColor();
		counter = (counter + 1) % siteswap.length;
		drawString(jc, Color.RED);
		jc.setForegroundColor();
	}
	
	private void drawString(JugglerCanvas jc, int color) {
// edit {
//		jc.drawString(siteswap[counter], posX[counter], 1, Graphics.TOP|Graphics.LEFT);
		jc.drawString(siteswap[counter], posX[counter], Resource.charHeight() + 2, 0, color);
// }
	}
}