package com.jm.gen;

public class GenProc {
	private int miBalls;
	private int miLength;
	private int miMode;
	//private int miMulti;
	private int miMax;
	//private int[] miInclude = new int[37];

	private int[] iAddPatt;
	private int[] iBasePatt;
	private int[] iPatt;
	private int[] d;
	private int[] p;

	private int miBaseBalls;
	private int miCycle;
	private int miOverMax;

	//private boolean mbAlloc = false;
	private boolean mbCross;
	//static boolean mpbCancel;
	private MainGen main;
	
	public GenProc(MainGen main){
		this.main = main;
	}
	
	public void init(int miBalls, int miLength){
		this.miBalls = miBalls;
		this.miLength = miLength;
		mbCross = false;
	}
	
	public void setMode(int miMode){
		this.miMode = miMode;
	}
	
	public void setHeight(int miMax){
		this.miMax = miMax;
	}
	
	private boolean SPattToIPatt(char[] sPatt) {
		int i, j;
		if (miMode == MainGen.SPT_NORMAL)
			for (i = 0; i < miLength; i++)
				iPatt[i] = StdLib.ctod(sPatt[i]);

		if (miMode == MainGen.SPT_SYNCHRO)
			for (j = i = 0; i < miLength; i += 2) {
				j++; // '(' ΂
				// if((j+1)[sPatt]=='x'){
				if (sPatt[j + 1] == 'x') {
					iPatt[i] = StdLib.ctod(sPatt[j]) + 1;
					j += 2;
				} else {
					// iPatt[i]=ctod(j[sPatt]);
					iPatt[i] = StdLib.ctod(sPatt[j]);
					j++;
				}
				j++; // ',' ΂
				if (sPatt[j + 1] == 'x') {
					iPatt[i + 1] = StdLib.ctod(sPatt[j]) - 1;
					j += 2;
				} else {
					iPatt[i + 1] = StdLib.ctod(sPatt[j]);
					j++;
				}
				j++; // ')' ΂
			}
		return true;
	}

	private int IPattToSPatt(char[] sPatt) {
		int i, j;
		if (miMode == MainGen.SPT_NORMAL) {
			for (i = j = 0; i < miLength; i++) {
				sPatt[j++] = StdLib.dtoc(iPatt[i]);
			}
			sPatt[j] = '\0';
			return j;
		}
		if (miMode == MainGen.SPT_SYNCHRO) {
			for (i = j = 0; i < miLength; i += 2) {
				sPatt[j++] = '(';
				if (StdLib.toBoolean(iPatt[i] % 2)) {
					sPatt[j++] = StdLib.dtoc(iPatt[i] - 1);
					sPatt[j++] = 'x';
				} else {
					sPatt[j++] = StdLib.dtoc(iPatt[i]);
				}
				sPatt[j++] = ',';
				if (StdLib.toBoolean(iPatt[i + 1] % 2)) {
					sPatt[j++] = StdLib.dtoc(iPatt[i + 1] + 1);
					sPatt[j++] = 'x';
				} else {
					sPatt[j++] = StdLib.dtoc(iPatt[i + 1]);
				}
				sPatt[j++] = ')';
			}
			sPatt[j] = '\0';
			return j;
		}
		return 0;
	}

	private boolean MatchBasePatt() {
		// int i, j, x;
		int i, j = -1, x;
		if (miBaseBalls > miBalls || miOverMax > 0)
			return false;
		if (miMode == MainGen.SPT_NORMAL) {
			for (i = 1; i < miLength; i++) {
				for (j = 0; j < miLength
						&& iBasePatt[j] == iBasePatt[(j + i) % miLength]; j++)
					;
				if (j == miLength
						|| iBasePatt[j] < iBasePatt[(j + i) % miLength])
					break;
			}
			if (i == miLength || j == miLength) {
				miCycle = i;
				return true;
			}
		}
		if (miMode == MainGen.SPT_SYNCHRO) {
			for (j = 0; j < miLength
					&& iBasePatt[j] - (iBasePatt[j] & 1) == iBasePatt[j + 1]
							+ (iBasePatt[j + 1] & 1); j += 2)
				;
			if (j == miLength)
				mbCross = true;
			else if (iBasePatt[j] - (iBasePatt[j] & 1) < iBasePatt[j + 1]
					+ (iBasePatt[j + 1] & 1))
				return false;
			else
				mbCross = false;
			for (i = 2; i < miLength; i++) {
				for (j = 0; j < miLength
						&& iBasePatt[j] == iBasePatt[(j + i) % miLength]; j++)
					;
				if (j == miLength
						|| iBasePatt[j] < iBasePatt[(j + i) % miLength])
					break;
				i++;
				for (j = 0; j < miLength
						&& iBasePatt[j] - (iBasePatt[j] & 1) == iBasePatt[(j + i)
								% miLength]
								+ (iBasePatt[(j + i) % miLength] & 1)
						&& iBasePatt[j + 1] + (iBasePatt[j + 1] & 1) == iBasePatt[(j
								+ i - 1)
								% miLength]
								- (iBasePatt[(j + i - 1) % miLength] & 1); j += 2)
					;
				if (j == miLength
						|| (x = iBasePatt[j] - (iBasePatt[j] & 1)
								- iBasePatt[(j + i) % miLength]
								+ (iBasePatt[(j + i) % miLength] & 1)) < 0
						|| ((x == 0) && iBasePatt[j + 1]
								+ (iBasePatt[j + 1] & 1) < iBasePatt[(j + i - 1)
								% miLength]
								- (iBasePatt[(j + i - 1) % miLength] & 1)))
					break;
			}
			if (i == miLength || j == miLength) {
				miCycle = i;
				return true;
			}
		}
		return false;
	}

	private boolean EnumBasePatt() {
		int i, j, k, temp;
		do {
			//if (mpbCancel)
			//	return false;
			if (main.isCancel()){
				return false;
			}
			k = -1;
			for (i = miLength - 1; i > 0; i--) {
				p[i] += d[i];
				if (p[i] == i + 1)
					d[i] = -1;
				else {
					if (p[i] != 0) {
						j = p[i] + k;
						miOverMax = miOverMax
								- StdLib.toInt(iBasePatt[j] > miMax)
								- StdLib.toInt(iBasePatt[j + 1] > miMax);
						miBaseBalls = miBaseBalls
								+ StdLib.toInt(iBasePatt[j] == 0)
								- StdLib.toInt(iBasePatt[j] > miLength)
								- StdLib.toInt(iBasePatt[j + 1] >= miLength - 1);
						temp = (iBasePatt[j] + miLength - 1) % miLength;
						iBasePatt[j] = (iBasePatt[j + 1] + 1) % miLength;
						iBasePatt[j + 1] = temp;
						if (miMode == MainGen.SPT_SYNCHRO) { // 0x oȂ悤ɂ
							if (StdLib.toBoolean(j & 1)) {
								if (iBasePatt[j + 1] == 1) {
									iBasePatt[j + 1] += miLength;
									miBaseBalls++;
								}
							} else if (iBasePatt[j] == 1) {
								iBasePatt[j] += miLength;
								miBaseBalls++;
							}
						}
						miOverMax = miOverMax
								+ StdLib.toInt(iBasePatt[j] > miMax)
								+ StdLib.toInt(iBasePatt[j + 1] > miMax);
						
						// ǉ
						if (miOverMax >= miBalls && miBalls == miMax){
							return false;
						}
						
						return true;
					}
					d[i] = 1;
					k++;
				}
			}
		} while (i != 0);
		return false;
	}

	boolean EnumAddPatt() {
		int i, j, k;
		//if (mpbCancel)
		//	return false;
		if (main.isCancel()){
			return false;
		}
		for (i = miLength - 1; i >= 0; i--)
			if (StdLib.toBoolean(iAddPatt[i])) {
				for (j = i + 1; j < miLength
						&& iBasePatt[j] + iAddPatt[j] + miLength > miMax; j++)
					;
				if (j < miLength) {
					iAddPatt[i] -= miLength;
					iAddPatt[j] += miLength;
					k = miLength - 1;
					while (k > i)
						if (StdLib.toBoolean(iAddPatt[k])) {
							while (j < k
									&& iBasePatt[j] + iAddPatt[j] + miLength > miMax)
								j++;
							if (j < k) {
								iAddPatt[k] -= miLength;
								iAddPatt[j] += miLength;
							} else
								k--;
						} else
							k--;
					return true;
				}
			}
		return false;
	}

	private boolean Match() {
		int i, j;
		if (miMode == MainGen.SPT_NORMAL) {
			for (i = miCycle; i < miLength; i += miCycle) {
				for (j = 0; j < miLength
						&& iAddPatt[j] == iAddPatt[(i + j) % miLength]; j++)
					;
				if (j == miLength || iAddPatt[j] < iAddPatt[(i + j) % miLength])
					break;
			}
			if (i < miLength)
				return false;
			for (i = 0; i < miLength; i++)
				iPatt[i] = iBasePatt[i] + iAddPatt[i];
			// ׂ܂܂ĂȂ
			// for(i=0;i<miLength;i++)
			// if(mbExclude[iPatt[i]]==true)
			// return false;
			// ܂ނׂ܂܂Ă
			// for(i=0;miInclude[i]!=-1;i++){
			// for(j=0;j<miLength&&iPatt[j]!=miInclude[i];j++);
			// if(j==miLength)
			// return FALSE;
			// }
			return true;
		}
		if (miMode == MainGen.SPT_SYNCHRO) {
			if (mbCross) {
				for (i = 0; i < miLength
						&& iAddPatt[i] - (iAddPatt[i] & 1) * 2 == iAddPatt[i + 1]; i += 2)
					;
				if (i < miLength
						&& iAddPatt[i] - (iAddPatt[i] & 1) * 2 < iAddPatt[i + 1])
					return false;
			}
			if (StdLib.toBoolean(miCycle & 1)) {
				for (i = (miCycle - 1) * 2; i < miLength; i += (miCycle - 1) * 2) {
					for (j = 0; j < miLength
							&& iAddPatt[j] == iAddPatt[(i + j) % miLength]; j++)
						;
					if (j == miLength
							|| iAddPatt[j] < iAddPatt[(i + j) % miLength])
						break;
				}
				if (i < miLength)
					return false;
				for (i = miCycle - 1; i < miLength; i += (miCycle - 1) * 2) {
					for (j = 0; j < miLength
							&& iBasePatt[j] - (iBasePatt[j] & 1) == iBasePatt[(j + i)
									% miLength]
									+ (iBasePatt[(j + i) % miLength] & 1)
							&& iBasePatt[j + 1] + (iBasePatt[j + 1] & 1) == iBasePatt[(j
									+ i - 1)
									% miLength]
									- (iBasePatt[(j + i - 1) % miLength] & 1); j += 2)
						;
					if (j < miLength
							&& (iBasePatt[j] - (iBasePatt[j] & 1) < iBasePatt[(j + i)
									% miLength]
									+ (iBasePatt[(j + i) % miLength] & 1) || (iBasePatt[j]
									- (iBasePatt[j] & 1) == iBasePatt[(j + i)
									% miLength]
									+ (iBasePatt[(j + i) % miLength] & 1) && iBasePatt[j + 1]
									+ (iBasePatt[j + 1] & 1) < iBasePatt[(j + i - 1)
									% miLength]
									- (iBasePatt[(j + i - 1) % miLength] & 1))))
						break;
				}
				if (i < miLength)
					return false;
			} else {
				for (i = miCycle; i < miLength; i += miCycle) {
					for (j = 0; j < miLength
							&& iAddPatt[j] == iAddPatt[(j + i) % miLength]; j++)
						;
					if (j == miLength
							|| iAddPatt[j] < iAddPatt[(j + i) % miLength])
						break;
				}
				if (i < miLength)
					return false;
			}
			for (i = 0; i < miLength; i++)
				iPatt[i] = iBasePatt[i] + iAddPatt[i];
			// ׂ܂܂ĂȂ
			// for(i=0;i<miLength;i++)
			// if(mbExclude[iPatt[i]+(i&1)*(iPatt[i]&1)*2]==true)
			// return false;
			// ܂ނׂ܂܂Ă
			// for(i=0;miInclude[i]!=-1;i++){
			// for(j=0;j<miLength&&iPatt[j]+(j&1)*(iPatt[j]&1)*2!=miInclude[i];j++);
			// if(j==miLength)
			// return false;
			// }
			return true;
		}
		// ǉ
		return true;
	}

	private boolean PackPatt() {
		int i, j;
		for (i = 0; i < miLength; i++)
			iAddPatt[i] = 0;
		for (i = miBaseBalls, j = 0; i < miBalls; i++) {
			while (j < miLength
					&& iBasePatt[j] + iAddPatt[j] + miLength > miMax)
				j++;
			if (j == miLength)
				return false;
			iAddPatt[j] += miLength;
		}
		return true;
	}

	public int EnumSiteswap(char[] sPatt) {
		do {
			while (EnumAddPatt())
				if (Match())
					return IPattToSPatt(sPatt);
			do
				if (!EnumBasePatt()) {
					sPatt[0] = '\0';
					return 0;
				}
			while (!MatchBasePatt() || !PackPatt());
		} while (!Match());
		return IPattToSPatt(sPatt);
	}

	private boolean InitBasePatt(char[] sPatt) {
		int i, j, k, temp, check = 0;
		SPattToIPatt(sPatt);
		for (i = 0; i < miLength; i++) {
			iAddPatt[i] = (iPatt[i] / miLength) * miLength;
			iPatt[i] -= iAddPatt[i];
			if (iPatt[i] == 0)
				check++;
			p[i] = 0;
			d[i] = 1;
			iBasePatt[i] = 0;
		}
		while (check != miLength) {
			//if (mpbCancel)
			//	return false;
			if (main.isCancel()){
				return false;
			}
			k = -1;
			for (i = miLength - 1; i > 0; i--) {
				p[i] += d[i];
				if (p[i] == i + 1)
					d[i] = -1;
				else {
					if (p[i] != 0) {
						j = p[i] + k;
						check = check
								- StdLib.toInt(iBasePatt[j] == iPatt[j])
								- StdLib.toInt(iBasePatt[j + 1] == iPatt[j + 1]);
						temp = (iBasePatt[j] + miLength - 1) % miLength;
						iBasePatt[j] = (iBasePatt[j + 1] + 1) % miLength;
						iBasePatt[j + 1] = temp;
						check = check
								+ StdLib.toInt(iBasePatt[j] == iPatt[j])
								+ StdLib.toInt(iBasePatt[j + 1] == iPatt[j + 1]);
						break;
					}
					d[i] = 1;
					k++;
				}
			}
			if (i == 0)
				return false;
		}
		if (miMode == MainGen.SPT_SYNCHRO)
			for (i = 0; i < miLength; i += 2)
				if (iBasePatt[i] == 1) {
					iBasePatt[i] += miLength;
					iAddPatt[i] -= miLength;
				}
		for (i = miBaseBalls = miOverMax = 0; i < miLength; i++) {
			miBaseBalls += iBasePatt[i];
			miOverMax += StdLib.toInt(iBasePatt[i] > miMax);
		}
		miBaseBalls /= miLength;
		return true;
	}

	public int InitGenerator(char[] sPatt) {
		int i;
		// int j;

		// VNŎ͍̂̂lȂ
		if (miMode == MainGen.SPT_SYNCHRO && StdLib.toBoolean(miLength & 1))
			return -1;

		// BUFFLEN zp^[ꂻȒ,͍lȂ
		if (miLength > StdLib.BUFFLEN || miMode == MainGen.SPT_SYNCHRO
				&& miLength > StdLib.BUFFLEN / 7)
			return -1;

		// Exclude,Include ̐ݒ
		// 폜

		// miMax  Exclude 狁߂B
		// C
		//miMax = 5;

		// iPatt,iBasePattc ̊m
		TermGenerator();
		iPatt = new int[miLength];
		iBasePatt = new int[miLength];
		iAddPatt = new int[miLength];
		d = new int[miLength];
		p = new int[miLength];

		// sPatt ɍ킹,iBasePatt,iAddPatt cݒ肵,̃p^[𐶐
		if (StdLib.strlen(sPatt) == 0) {
			for (i = 0; i < miLength; i++) {
				p[i] = 0;
				d[i] = 1;
				iBasePatt[i] = 0;
			}
			miCycle = 1;
			if (miMode == MainGen.SPT_SYNCHRO) {
				miCycle = 2;
				mbCross = true;
			}
			miBaseBalls = 0;
			miOverMax = 0;
		} else if (!InitBasePatt(sPatt)) {
			sPatt[0] = '\0';
			return 0;
		} else if (MatchBasePatt())
			return EnumSiteswap(sPatt);

		while (!PackPatt())
			if (!EnumBasePatt()) {
				sPatt[0] = '\0';
				return 0;
			}
		if (Match())
			return IPattToSPatt(sPatt);
		else
			return EnumSiteswap(sPatt);
	}

	private boolean TermGenerator() {
		//free(iPatt);
		//free(iBasePatt);
		//free(iAddPatt);
		//free(d);
		//free(p);
		iPatt = null;
		iBasePatt = null;
		iAddPatt = null;
		d = null;
		p = null;
		
		return true;
	}
}
