package com.jm.db;

import android.content.Context;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

import com.jm.PatternList;
import com.jm.utility.Debug;
import com.jm.utility.JmException;

public class DatabaseHelper extends SQLiteOpenHelper {
	private static DatabaseHelper instance = null;

	public static DatabaseHelper getInstance() {
		return instance;
	}

	public static void init(Context context) throws JmException {
		if (instance != null){
			return;
		}
		DatabaseHelper helper = new DatabaseHelper(context);
		SQLiteDatabase db = helper.getWritableDatabase();
		int count;
		count = Dao.getInstance().count();
		Dao.getInstance().start(db);
		if (count <= 0) {
			new PatternList();
		}
	}

	public DatabaseHelper(Context context) {
		super(context, "JuggleMaster.db", null, 1);
		instance = this;
	}

	@Override
	public void onCreate(SQLiteDatabase db) {
		db.beginTransaction();
		try {
			Dao.getInstance().init(db);
			db.setTransactionSuccessful();
		} catch (SQLException e) {
			Debug.d(this, null, e);
			throw e;
		} finally {
			db.endTransaction();
		}
	}

	@Override
	public void onUpgrade(SQLiteDatabase arg0, int arg1, int arg2) {

	}
}
