function Juggler(){
	this.initialize.apply(this);
}

Juggler.ST_IDLE = 0x0;
Juggler.ST_PAUSE = 0x1;
Juggler.ST_PLAYING = 0x2;

Juggler.interval = null;

Juggler.prototype = {
	delayTime: 0,
	frameRate: 10,
		body: null,
	siteswap: null,
	balls: null,
	site: null,

	initialize: function() {
		this.body = new Body();
		this.balls = new JugglingBalls(
			this.body.getRightHand(), this.body.getLeftHand());
	},
	getSiteSwap: function() {
		return this.site;
	},
	play: function() {
		this.status = this.ST_PLAYING;
	},
	pause: function() {
		this.status = this.ST_PAUSE;
	},
	stop: function() {
        this.delayTime = 0;
		this.status = this.ST_IDLE;
    },
	isPlaying: function() {
		return (this.status == this.ST_PLAYING);
	},
	isPause: function() {
		return (this.status == this.ST_PAUSE);
	},
	isIdle: function() {
		return (this.status == this.ST_IDLE);
	},
	start: function(jp){
		this.stop();
		if (!this.balls.initialize_func(jp)){
			return;
		}
		this.site = jp.getSiteSwap();
		this.siteswap = new SiteswapWriter(this.site);

		if (Juggler.interval){
			clearInterval(Juggler.interval);
		}
		this.delayTime = (20 - Resource.speed) * 100 / this.frameRate + 1;
		Juggler.interval = setInterval(doCanvas, this.delayTime);

		this.play();
	},
	drawJuggler: function(counter) {
		this.balls.juggle(counter);
		this.body.move();
		jCanvas.clear();
		if(JmPattern.ifShowBody()) {
			this.body.drawBody(jCanvas);
		}
		if(JmPattern.ifShowSiteSwap()) {
			this.siteswap.drawSiteswap(jCanvas);
		}
		this.balls.drawBalls();
	}
};
