function JmPattern(){
	this.initialize.apply(this);
}

JmPattern.NORMAL = [13, 0, 4, 0];
JmPattern.NORMAL_PATTERN = new Array();
	JmPattern.NORMAL_PATTERN[0] = JmPattern.NORMAL;
JmPattern.speed = 10;
JmPattern.mirror = false;
JmPattern.showBody = true;
JmPattern.showSiteswap = true;

JmPattern.reverse = function(pattern) {
	return [ pattern[2], pattern[1], pattern[0], pattern[3] ];
};
JmPattern.getSpeed = function(){
	return JmPattern.speed;
};
JmPattern.ifMirror = function(){
	return JmPattern.mirror;
};
JmPattern.ifShowBody = function() {
	return JmPattern.showBody;
}
JmPattern.ifShowSiteSwap = function(){
	return JmPattern.showSiteswap;
};
JmPattern.setSpeed = function(s){
	JmPattern.speed = s;
};
JmPattern.setIfMirror = function(b){
	JmPattern.mirror = b;
};
JmPattern.setIfShowBody = function(b){
	JmPattern.showBody = b;
};
JmPattern.setIfShowSiteSwap = function(b){
	JmPattern.showSiteswap = b;
};

JmPattern.prototype = {
	siteswap: null,
	height: 0,
	dwell: 0,
	name: null,
	motion: null,

	initialize: function() {
		this.siteswap = null;
	},
	motionSize: function(){
		return this.motion.length;
	},
	getName: function(){
		return this.name;
	},
	getHeight: function(){
		return this.height;
	},
	getDwell: function(){
		return this.dwell;
	},
	getSiteSwap: function(){
		return this.siteswap;
	},
	getThrowPositionX: function(index){
		return this.motion[index % this.motion.length][0];
	},
	getThrowPositionY: function(index){
		return this.motion[index % this.motion.length][1];
	},
	getCatchPositionX: function(index){
		return this.motion[index % this.motion.length][2];
	},
	getCatchPositionY: function(index){
		return this.motion[index % this.motion.length][3];
	},
	motionToString: function() {
		var buf = "";
		var i;
		for (i = 0; i < this.motion.length; i++) {
			buf += '{'
			buf += this.motion[i][0] + ',';
			buf += this.motion[i][1] + "}{";
			buf += this.motion[i][2] + ',';
			buf += this.motion[i][3] + '}';
		}
		return buf;
	},
	setName: function(name){
		this.name = name;
	},
	setHeight: function(height){
		this.height = height;
	},
	setDwell: function(dwell){
		this.dwell = dwell;
	},
	s: function(a0, a1, a2, a3, a4){
		if (a4){
			return this.set(a0, a1, a2, a3, a4);
		}
		if (a3){
			return this.set2(a0, a1, a2, a3);
		}
		if (a2){
			if (typeof a2 == 'object'){
				return this.set1(a0, a1, a2);
			}
			else {
				return this.set5(a0, a1, a2);
			}
		}
		if (a1){
			if (typeof a1 == 'string'){
				return this.set0(a0, a1);
			}
			else {
				return this.set4(a0, a1);
			}
		}
		return this.set3(a0);
	},
	set0: function(name, siteswap) {
		this.set2(name, siteswap, 20, 50);
		return this;
	},
	set1: function(name, siteswap, motion) {
		this.set(name, siteswap, 20, 50, motion);
		return this;
	},
	set2: function(name, siteswap, height, dwell) {
		this.set(name, siteswap, height, dwell, JmPattern.NORMAL_PATTERN);
		return this;
	},
	set3: function(siteswap) {
		this.set4(siteswap, JmPattern.NORMAL_PATTERN);
		return this;
	},
	set4: function(siteswap, motion) {
		this.set(siteswap, siteswap, 20, 50, motion);
		return this;
	},
	set5: function(siteswap, height, dwell) {
		this.set2(siteswap, siteswap, height, dwell);
		return this;
	},
	set: function(name, siteswap, height, dwell, motion) {
		this.name = name;
		this.siteswap = SiteSwap.getInstance(siteswap);
		this.motion = motion;
		this.height = height;
		this.dwell = dwell;
		return this;
	}
};

