/* ꡼ΥåԤ */
#if 0		/* Patched by G-HAL */
#include <stdio.h>
#include <stdlib.h>
#include <anthy/anthy.h>
#include <anthy/xstr.h>
#else
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if defined(HAVE_STDIO_H)
# include <stdio.h>
#endif

#include "anthy/anthy.h"
#include "anthy/xstr.h"
#endif

static int
init(void)
{
  int res;

  res = anthy_init();
  if (res) {
    printf("failed to init\n");
    return 1;
  }
  anthy_quit();
  /* init again */
  res = anthy_init();
  if (res) {
    printf("failed to init\n");
    return 1;
  }
  return 0;
}

static int
test0(void)
{
  anthy_context_t ac;
  ac = anthy_create_context();
  if (!ac) {
    printf("failed to create context\n");
    return 1;
  }
  anthy_release_context(ac);
  return 0;
}

static int
test1(void)
{
  anthy_context_t ac;
  char buf[100];
  xstr *xs;
  ac = anthy_create_context();
  if (!ac) {
    printf("failed to create context\n");
    return 1;
  }
 #if 0	/* Patched by G-HAL, Sat,13 Jun,2009 */
  anthy_set_string(ac, "");
 #else
  anthy_set_string(ac, "ѤԤפڤݡ");
 #endif
  if (anthy_get_segment(ac, 0, NTH_UNCONVERTED_CANDIDATE, buf, 100) > 0) {
    printf("(%s)\n", buf);
  }
  if (anthy_get_segment(ac, 0, NTH_KATAKANA_CANDIDATE, buf, 100) > 0) {
    printf("(%s)\n", buf);
  }
  if (anthy_get_segment(ac, 0, NTH_HIRAGANA_CANDIDATE, buf, 100) > 0) {
    printf("(%s)\n", buf);
  }
  if (anthy_get_segment(ac, 0, NTH_HALFKANA_CANDIDATE, buf, 100) > 0) {
    printf("(%s)\n", buf);
  }
  anthy_release_context(ac);
  xs = anthy_cstr_to_xstr("", 0);
 #if 0	/* Patched by G-HAL, Sat,13 Jun,2009 */
  xs = anthy_cstr_to_xstr("", 0);
  xs = anthy_xstr_hira_to_half_kata(xs);
  anthy_putxstrln(xs);
 #else
  { xstr* const xs_src = anthy_cstr_to_xstr("ѤԤפڤݡ", 0);
    xs = anthy_xstr_hira_to_half_kata( xs_src );
    anthy_putxstrln( xs );
    anthy_free_xstr( xs );
    xs = anthy_xstr_hira_to_kata( xs_src );
    anthy_putxstrln( xs );
    anthy_free_xstr( xs );
    anthy_free_xstr( xs_src );
  }
 #endif
  return 0;
}

static int
shake_test(const char *str)
{
  int i;
  anthy_context_t ac;
  ac = anthy_create_context();
  if (!ac) {
    printf("failed to create context\n");
    return 1;
  }
  anthy_set_string(ac, str);
  for (i = 0; i < 50; i++) {
    int res, nth, rsz;
    struct anthy_conv_stat cs;
    res = anthy_get_stat(ac, &cs);
    nth = rand() % cs.nr_segment;
    rsz = (rand() % 3) - 1;
    anthy_resize_segment(ac, nth, rsz);
  }
  anthy_release_context(ac);
  return 0;
}

int
main(_unused int argc, _unused char **argv)
{
  printf("checking\n");
  if (init()) {
    printf("fail (init)\n");
    return 0;
  }
  if (test0()) {
    printf("fail (test0)\n");
  }
  if (test1()) {
    printf("fail (test1)\n");
  }
  if (shake_test("")) {
    printf("fail (shake_test)\n");
  }
  anthy_quit();		/* Patched by G-HAL, Sun,25 Sep,2011 */
  printf("done\n");
  return 0;
}
/* vim:ts=8 sw=2 nomodified:
 */
