/*
 * Ŀͼ򰷤Υ
 *
 * 桼ŪϿñǤʤ
 * ̤θưŪ˳ؽƴAPIġ
 *
 * Copyright (C) 2000-2007 TABATA Yusuke
 */
/*
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */
#if 0		/* Patched by G-HAL */
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <fcntl.h>
#include <unistd.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include <anthy/anthy.h>
#include <anthy/alloc.h>
#include <anthy/dic.h>
#include <anthy/record.h>
#include <anthy/dicutil.h>
#include <anthy/conf.h>
#include <anthy/logger.h>
#include <anthy/texttrie.h>
#include <anthy/textdict.h>
#include <anthy/word_dic.h>
#include "dic_main.h"
#include "dic_ent.h"
#else
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if defined(HAVE_MALLOC_H)
# include <malloc.h>
#endif
#if defined(HAVE_UNISTD_H)
# include <unistd.h>
#endif
#if defined(HAVE_SYS_TYPES_H)
# include <sys/types.h>
#endif
#if defined(HAVE_SYS_STAT_H)
# include <sys/stat.h>
#endif
#if defined(STAT_MACROS_BROKEN)
# error	"STAT_MACROS_BROKEN"	/* S_IS* is broken. */
#endif
#if defined(HAVE_DIRENT_H)
# include <dirent.h>
# define NAMLEN(dirent) strlen((dirent)->d_name)
#else
# define dirent direct
# define NAMLEN(dirent) (dirent)->d_namlen
# if defined(HAVE_SYS_NDIR_H)
#  include <sys/ndir.h>
# endif
# if defined(HAVE_SYS_DIR_H)
#  include <sys/dir.h>
# endif
# if defined(HAVE_NDIR_H)
#  include <ndir.h>
# endif
#endif
#if defined(HAVE_FCNTL_H)
# include <fcntl.h>
#endif
#if defined(HAVE_STRING_H)
# include <string.h>
#endif
#if defined(HAVE_STRINGS_H)
# include <strings.h>
#endif
#if defined(HAVE_STDIO_H)
# include <stdio.h>
#endif
#if defined(HAVE_ERRNO_H)
# include <errno.h>
#endif
#if defined(HAVE_ALLOCA_H)
# include <alloca.h>
#elif defined(HAVE_ALLOCA)
#else
# error	"alloca() was not found."
#endif

#include "anthy/settings.h"		/* Patched by G-HAL, Fri,17 Oct,2008 */
#include "anthy/anthy.h"
#include "anthy/alloc.h"
#include "anthy/dic.h"
#include "anthy/record.h"
#include "anthy/dicutil.h"
#include "anthy/conf.h"
#include "anthy/logger.h"
#include "anthy/texttrie.h"
#include "anthy/textdict.h"
#include "anthy/word_dic.h"
#include "dic_main.h"
#include "dic_ent.h"
#endif

/* Ŀͼ */
struct text_trie *anthy_private_tt_dic;
struct textdict *anthy_private_text_dic;
static struct textdict *anthy_imported_text_dic;
static char *imported_dic_dir;
/* åѤѿ */
static char *lock_fn;
static int lock_depth;
static int lock_fd;

#define MAX_DICT_SIZE 100000000

/* ĿͼΥǥ쥯ȥ̵ͭǧ */
void
anthy_check_user_dir(void)
{
  struct stat st;
 #if 0	/* Patched by G-HAL, Sat,18 Oct,2008 */
  const char *hd;
  char *dn;
  hd = anthy_conf_get_str("HOME");
  dn = alloca(strlen(hd) + 10);
  sprintf(dn, "%s/.anthy", hd);
 #else
  const char* const hd = anthy_conf_get_str("HOME");
  const size_t dn_len = strlen(hd)
      + strlen(anthy_settings.filename.PathSeparator)
      + strlen(anthy_settings.filename.user_dir)
      + 1;
  char* dn = (char*) alloca( dn_len );
  snprintf(dn, dn_len,
	   "%s%s%s",
	   hd,
	   anthy_settings.filename.PathSeparator,
	   anthy_settings.filename.user_dir );
 #endif
  if (stat(dn, &st) || !S_ISDIR(st.st_mode)) {
    int r;
    /*fprintf(stderr, "Anthy: Failed to open anthy directory(%s).\n", dn);*/
    r = mkdir(dn, S_IRWXU);
    if (r == -1){
      anthy_log(0, "Failed to create profile directory\n");
      return ;
    }
    /*fprintf(stderr, "Anthy: Created\n");*/
    r = chmod(dn, S_IRUSR | S_IWUSR | S_IXUSR);
    if (r == -1) {
      anthy_log(0, "But failed to change permission.\n");
    }
  }
}

static void
init_lock_fn(const char *home, const char *id)
{
 #if 0	/* Patched by G-HAL, Sat,18 Oct,2008 */
  lock_fn = malloc(strlen(home) + strlen(id) + 40);
  sprintf(lock_fn, "%s/.anthy/lock-file_%s", home, id);
 #else
  const size_t fn_len = strlen(home)
      + strlen(anthy_settings.filename.PathSeparator)
      + strlen(anthy_settings.filename.user_dir)
      + strlen(anthy_settings.filename.PathSeparator)
      + strlen(anthy_settings.filename.lock_file)
      + strlen(id)
      + 1;
  lock_fn = (char*) malloc( fn_len );
  snprintf(lock_fn, fn_len,
	   "%s%s%s%s%s%s",
	   home,
	   anthy_settings.filename.PathSeparator,
	   anthy_settings.filename.user_dir,
	   anthy_settings.filename.PathSeparator,
	   anthy_settings.filename.lock_file,
	   id );
 #endif
}

static struct text_trie *
open_tt_dic(const char *home, const char *id)
{
  struct text_trie *tt;
 #if 0	/* Patched by G-HAL, Sat,18 Oct,2008 */
  char *buf = malloc(strlen(home) + strlen(id) + 40);
  sprintf(buf, "%s/.anthy/private_dict_%s.tt", home, id);
 #else
  const size_t fn_len = strlen(home)
      + strlen(anthy_settings.filename.PathSeparator)
      + strlen(anthy_settings.filename.user_dir)
      + strlen(anthy_settings.filename.PathSeparator)
      + strlen(anthy_settings.filename.private_dic)
      + strlen(id)
      + strlen(anthy_settings.filename.private_dic_ext)
      + 1;
  char* buf = (char*) malloc( fn_len );
  snprintf(buf, fn_len,
	   "%s%s%s%s%s%s%s",
	   home,
	   anthy_settings.filename.PathSeparator,
	   anthy_settings.filename.user_dir,
	   anthy_settings.filename.PathSeparator,
	   anthy_settings.filename.private_dic,
	   id,
	   anthy_settings.filename.private_dic_ext );
 #endif
  tt = anthy_trie_open(buf, 0);
  free(buf);
  return tt;
}

static struct textdict *
open_textdic(const char *home, const char *name, const char *id)
{
  struct textdict *td;
 #if 0	/* Patched by G-HAL, Sat,18 Oct,2008 */
  char *fn = malloc(strlen(home) + strlen(name) + strlen(id) + 10);
  sprintf(fn, "%s/.anthy/%s%s", home, name, id);
 #else
  const size_t fn_len = strlen(home)
      + strlen(anthy_settings.filename.PathSeparator)
      + strlen(anthy_settings.filename.user_dir)
      + strlen(anthy_settings.filename.PathSeparator)
      + strlen(name)
      + strlen(id)
      + 1;
  char* fn = (char*) malloc( fn_len );
  snprintf(fn, fn_len,
	   "%s%s%s%s%s%s",
	   home,
	   anthy_settings.filename.PathSeparator,
	   anthy_settings.filename.user_dir,
	   anthy_settings.filename.PathSeparator,
	   name,
	   id );
 #endif
  td = anthy_textdict_open(fn, 0);
  free(fn);
  return td;
}

void
anthy_priv_dic_lock(void)
{
  struct flock lck;
  lock_depth ++;
  if (lock_depth > 1) {
    return ;
  }
  if (!lock_fn) {
    /* ߥäƤ */
    lock_fd = -1;
    return ;
  }

  /* եåˡ¿뤬ˡcygwinǤưΤǺѤ */
  lock_fd = open(lock_fn, O_CREAT|O_RDWR, S_IREAD|S_IWRITE);
  if (lock_fd == -1) {
    return ;
  }

  lck.l_type = F_WRLCK;
  lck.l_whence = (short) 0;
  lck.l_start = (off_t) 0;
  lck.l_len = (off_t) 1;
  if (fcntl(lock_fd, F_SETLKW, &lck) == -1) {
    close(lock_fd);
    lock_fd = -1;
  }
}

void
anthy_priv_dic_unlock(void)
{
  lock_depth --;
  if (lock_depth > 0) {
    return ;
  }

  if (lock_fd != -1) {
    close(lock_fd);
    lock_fd = -1;
  }
}

void
anthy_priv_dic_update(void)
{
  if (!anthy_private_tt_dic) {
    return ;
  }

  anthy_trie_update_mapping(anthy_private_tt_dic);
}

/* seq_entɲä */
static void
add_to_seq_ent(const char *line, int encoding, struct seq_ent *seq)
{
  struct word_line wl;
  wtype_t wt;
 #if !defined(USE_ICONV)	/* Patched by G-HAL, Sun,14 Jun,2009 - Mon,15 Jun,2009 */
  xstr *xs;
 #else
  xstr xs;
  size_t len;
 #endif
  /* */
  if (anthy_parse_word_line(line, &wl)) {
    return ;
  }
 #if !defined(USE_ICONV)	/* Patched by G-HAL, Sun,14 Jun,2009 - Mon,15 Jun,2009 */
  xs = anthy_cstr_to_xstr(wl.word, encoding);
  anthy_type_to_wtype(wl.wt, &wt);
  anthy_mem_dic_push_back_dic_ent(seq, 0, xs, wt,
				  NULL, wl.freq, 0);
  anthy_free_xstr(xs);
 #else
  len = strlen( wl.word );
  xs.str = (xchar*) alloca( sizeof(xchar) * (len+1) );
  anthy_snputcstr( &xs, len+1, wl.word, encoding );
  anthy_type_to_wtype( wl.wt, &wt );
  anthy_mem_dic_push_back_dic_ent( seq, 0, &xs, wt, NULL, wl.freq, 0 );
 #endif
}

/* texttrieϿƤ뤫å
 * ϿƤseq_entɲä
 */
static void
copy_words_from_tt(struct seq_ent *seq, xstr *xs,
		   int encoding, const char *prefix)
{
  char *key, *v;
  int key_len;
  char *key_buf;
  int prefix_len = strlen(prefix);
  /**/
  if (!anthy_private_tt_dic) {
    return ;
  }
  key = anthy_xstr_to_cstr(xs, encoding);
  key_len = strlen(key);
  key_buf = (char*) malloc(key_len + 12);
  /* ˤϳñ줬ָФ XXXX(XXXXϥʸ)
   * Ȥ¸ƤΤ󤹤
   */
  sprintf(key_buf, "%s%s ", prefix, key);
  do {
    if (strncmp(&key_buf[2], key, key_len) ||
	strncmp(&key_buf[0], prefix, prefix_len) ||
	key_buf[key_len+2] != ' ') {
      /* ָФ פǻϤޤäƤʤΤоݳ */
      break;
    }
    /* ñɤ߽ФϿ */
    v = anthy_trie_find(anthy_private_tt_dic, key_buf);
    if (v) {
      add_to_seq_ent(v, encoding, seq);
    }
    free(v);
    /**/
  } while (anthy_trie_find_next_key(anthy_private_tt_dic,
				    key_buf, key_len + 8));
  free(key);
  free(key_buf);
}

void
anthy_copy_words_from_private_dic(struct seq_ent *seq,
				  xstr *xs, int is_reverse)
{
  if (is_reverse) {
    return ;
  }
  /* Ŀͼ񤫤äƤ */
  copy_words_from_tt(seq, xs, ANTHY_EUC_JP_ENCODING, "  ");
  copy_words_from_tt(seq, xs, ANTHY_UTF8_ENCODING, " p");
  /**/
 #if 0	/* Patched by G-HAL, Fri,17 Oct,2008, Wed,28 Jan,2009, Tue,10 Nov,2009 */
  if (!anthy_select_section("UNKNOWN_WORD", 0) &&
      !anthy_select_row(xs, 0)) {
    wtype_t wt;
    xstr *word_xs;
    anthy_type_to_wtype("#T35", &wt);
    word_xs = anthy_get_nth_xstr(0);
    anthy_mem_dic_push_back_dic_ent(seq, 0, word_xs, wt, NULL, 10, 0);
  }
 #else
  if ((!anthy_settings.anthy_mode.anonymous)
      && !anthy_select_section(UNKNOWN_WORD, 0)
      && !anthy_select_row(xs, 0)
  ) {
    wtype_t wt;
    xstr* const word_xs = anthy_get_nth_xstr(0);
    if (word_xs) {
      anthy_type_to_wtype("#T35", &wt);
      anthy_mem_dic_push_back_dic_ent(seq, 0, word_xs, wt, NULL, 10, 0);
    }
  }
 #endif
}

int
anthy_parse_word_line(const char *line, struct word_line *res)
{
  int i;
  const char *buf = line;
  /* default values */
  res->wt[0] = 0;
  res->freq = 1;
  res->word = NULL;
  /* ʻ٤parse */
  for (i = 0; i < 9 && *buf && *buf != '*' && *buf != ' '; buf++, i++) {
    res->wt[i] = *buf;
  }
  res->wt[i] = 0;
  if (*buf == '*') {
    buf ++;
    sscanf(buf, "%d", &res->freq);
    buf = strchr(buf, ' ');
  } else {
    res->freq = 1;
  }
  if (!buf || !(*buf)) {
    res->word = "";
    return -1;
  }
  buf++;
  /* ñ */
  res->word = buf;
  return 0;
}

void
anthy_ask_scan(void (*request_scan)(struct textdict *td, void *arg),
	       void *arg)
{
  DIR *dir;
  struct dirent *de;
  int size = 0;
  request_scan(anthy_private_text_dic, arg);
  request_scan(anthy_imported_text_dic, arg);
  dir = opendir(imported_dic_dir);
  if (!dir) {
    return ;
  }
  while ((de = readdir(dir))) {
    struct stat st_buf;
    struct textdict *td;
    char *fn = (char*) malloc(strlen(imported_dic_dir) +
		      strlen(de->d_name) + 3);
    if (!fn) {
      break;
    }
    sprintf(fn, "%s/%s", imported_dic_dir, de->d_name);
    if (stat(fn, &st_buf)) {
      free(fn);
      continue;
    }
    if (!S_ISREG(st_buf.st_mode)) {
      free(fn);
      continue;
    }
    size += st_buf.st_size;
    if (size > MAX_DICT_SIZE) {
      free(fn);
      break;
    }
    td = anthy_textdict_open(fn, 0);
    request_scan(td, arg);
    anthy_textdict_close(td);
    free(fn);
  }
 #if 0		/* Patched by G-HAL, Wed,13 Oct,2010 */
  closedir(dir);
 #else
 #if defined(CLOSEDIR_VOID)
  closedir(dir);
 #else
  const int closedir_ret = closedir(dir);
  if (0 != closedir_ret) {
    anthy_log(1, "Failed to closedir: %s\n", strerror(errno) );
  }
 #endif
 #endif
}

static void
add_unknown_word(xstr *yomi, xstr *word)
{
 #if 1	/* Patched by G-HAL, Tue,10 Nov,2009 */
  if (anthy_settings.anthy_mode.anonymous) {
    return;
  }
 #endif

  /* recordɲ */
  if (anthy_select_section(UNKNOWN_WORD, 1)) {	/* Patched by G-HAL, Fri,17 Oct,2008 */
    return ;
  }
	/* Patched by G-HAL, Sat,23 Aug,2008 */
  if (anthy_select_row_with_learn(yomi,1,1)) {
    return ;
  }
  anthy_set_nth_xstr(0, word);
  anthy_mark_row_used();
}

void
anthy_add_unknown_word(xstr *yomi, xstr *word)
{
 #if 0		/* Patched by G-HAL, Sun,10 May,2009 */
  if (!(anthy_get_xstr_type(word) & XCT_KATA) &&
      !(anthy_get_xstr_type(word) & XCT_HIRA)) {
    return ;
  }
  if (yomi->len < 4 || yomi->len > 30) {
    return ;
  }
  /**/
  add_unknown_word(yomi, word);
 #else
  const int type = anthy_get_xstr_type(word);
  if (!(XCT_KATA & type) && !(XCT_HIRA & type)) {
    return;
  }
  add_unknown_word(yomi, word);
 #endif
}

void
anthy_forget_unused_unknown_word(xstr *xs)
{
  char key_buf[128];
  char *v;

 #if 1	/* Patched by G-HAL, Tue,10 Nov,2009 */
  if (anthy_settings.anthy_mode.anonymous) {
    return;
  }
 #endif
  if (!anthy_private_tt_dic) {
    return ;
  }

  v = anthy_xstr_to_cstr(xs, ANTHY_UTF8_ENCODING);
  sprintf(key_buf, " U%s 0", v);
  free(v);
  anthy_trie_delete(anthy_private_tt_dic, key_buf);

  /* record˵Ͽ줿ʪä */
  if (anthy_select_section(UNKNOWN_WORD, 0)) {	/* Patched by G-HAL, Fri,17 Oct,2008 */
    return ;
  }
  if (!anthy_select_row(xs, 0)) {
    anthy_release_row();
  }
}

void
anthy_init_private_dic(const char *id)
{
  const char *home = anthy_conf_get_str("HOME");
  if (anthy_private_tt_dic) {
    anthy_trie_close(anthy_private_tt_dic);
  }
  /**/
  anthy_textdict_close(anthy_private_text_dic);
  anthy_textdict_close(anthy_imported_text_dic);
  /**/
  if (lock_fn) {
    free(lock_fn);
  }
  init_lock_fn(home, id);
  anthy_private_tt_dic = open_tt_dic(home, id);
  /**/
  anthy_private_text_dic = open_textdic(home, "private_words_", id);
  anthy_imported_text_dic = open_textdic(home, "imported_words_", id);
 #if 0	/* Patched by G-HAL, Sat,18 Oct,2008 */
  imported_dic_dir = malloc(strlen(home) + strlen(id) + 30);
  sprintf(imported_dic_dir, "%s/.anthy/imported_words_%s.d/", home, id);
 #else
  {
    const size_t fn_len = strlen(home)
	+ strlen(anthy_settings.filename.PathSeparator)
	+ strlen(anthy_settings.filename.user_dir)
	+ strlen(anthy_settings.filename.PathSeparator)
	+ strlen(anthy_settings.filename.imported_words)
	+ strlen(id)
	+ strlen(anthy_settings.filename.imported_words_ext)
	+ strlen(anthy_settings.filename.PathSeparator)
	+ 1;
    imported_dic_dir = (char*) malloc( fn_len );
    snprintf(imported_dic_dir, fn_len,
	     "%s%s%s%s%s%s%s%s",
	     home,
	     anthy_settings.filename.PathSeparator,
	     anthy_settings.filename.user_dir,
	     anthy_settings.filename.PathSeparator,
	     anthy_settings.filename.imported_words,
	     id,
	     anthy_settings.filename.imported_words_ext,
	     anthy_settings.filename.PathSeparator );
  }
 #endif
}

void
anthy_release_private_dic(void)
{
  if (anthy_private_tt_dic) {
    anthy_trie_close(anthy_private_tt_dic);
    anthy_private_tt_dic = NULL;
  }
  /**/
  anthy_textdict_close(anthy_private_text_dic);
  anthy_textdict_close(anthy_imported_text_dic);
  free(imported_dic_dir);
  anthy_private_text_dic = NULL;
  anthy_imported_text_dic = NULL;
  imported_dic_dir = NULL;
  /**/
  if (lock_depth > 0) {
    /* not sane situation */
    lock_depth = 0;
    if (lock_fn) {
      unlink(lock_fn);
    }
  }
  /**/
  free(lock_fn);
  lock_fn = NULL;
}
/* vim:ts=8 sw=2 nomodified:
 */
