/**@file
 *			Patches for Anthy, by G-HAL
 *@brief	(strlcpy|strlcat) شؿ
 *@date		Fri,31 Oct,2008
 *@date		Thu,14 Oct,2010
 *@author	Copyright(C)2008-2010 G-HAL
 */
#ifndef __ALTERNATIVE_STRLCPY_H__
#define __ALTERNATIVE_STRLCPY_H__

#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_SYS_TYPES_H)
# include <sys/types.h>
#endif


#if (!defined(HAVE_STRICMP) && defined(HAVE_CONFIG_H)) || (!defined(HAVE_CONFIG_H) && !defined(MSDOS))
# define	stricmp		strcasecmp
# define	strnicmp	strncasecmp
#endif


#if (!defined(HAVE_STRLCPY) && defined(HAVE_CONFIG_H))
# if defined(HAVE_G_STRLCPY)
#  define	strlcpy	g_strlcpy
# elif defined(HAVE_ALTERNATIVE_STRLCPY)
#  if defined(HAVE_STDDEF_H)
#   include <stddef.h>
#  endif
#  ifdef __cplusplus
extern "C" {
#  endif
extern size_t strlcpy(char *dst, const char *src, size_t size)
		__attribute__ ((__bounded__(__string__,1,3)));
#  ifdef __cplusplus
}
#  endif
#  define	ENABLE_ALTERNATIVE_STRLCPY
# else
#  error("A function strlcpy() or alternative function is required.")
# endif
#endif
#if (!defined(HAVE_STRLCAT) && defined(HAVE_CONFIG_H))
# if defined(HAVE_G_STRLCAT)
#  define	strlcat	g_strlcat
# elif defined(HAVE_ALTERNATIVE_STRLCAT)
#  if defined(HAVE_STDDEF_H)
#   include <stddef.h>
#  endif
#  ifdef __cplusplus
extern "C" {
#  endif
extern size_t strlcat(char *dst, const char *src, size_t size)
		__attribute__ ((__bounded__(__string__,1,3)));
#  ifdef __cplusplus
}
#  endif
#  define	ENABLE_ALTERNATIVE_STRLCAT
# else
#  error("A function strlcat() or alternative function is required.")
# endif
#endif


#endif /* __ALTERNATIVE_STRLCPY_H__ */
/* [ End of File ] */
/* vim:ts=4 sw=4 nomodified:
 */
