/**/
#ifndef _input_set_h_included_
#define _input_set_h_included_

#if 0		/* Patched by G-HAL */
#include <stdio.h>
#else
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDIO_H)
# include <stdio.h>
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif


struct input_set;
struct int_map;

struct input_line {
  /**/
  int weight;
  int negative_weight;
  /**/
  int nr_features;
  int *features;
  /**/
  struct input_line *next_line;
  struct input_line *next_in_hash;
};

extern struct input_set *input_set_create(void);
extern void input_set_set_features(struct input_set *is, int *features,
			    int nr, int strength);
extern struct input_set *input_set_filter(struct input_set *is,
				   double pos, double neg);
extern void input_set_output_feature_freq(FILE *fp, struct input_set *is);
/**/
extern struct input_line *input_set_get_input_line(struct input_set *is);


extern struct int_map *int_map_new(void);
extern int int_map_peek(struct int_map *im, int idx);
extern void int_map_set(struct int_map *im, int idx, int val);
extern void int_map_flatten(struct int_map *im);


#ifdef __cplusplus
}
#endif

#endif /* _input_set_h_included_ */
/* [ End of File ] */
/* vim:ts=8 sw=2 nomodified:
 */
