/* ¹򰷤Υ */
#ifndef _matrix_h_included_
#define _matrix_h_included_

#ifdef __cplusplus
extern "C" {
#endif


struct matrix_image {
  /* number of 'int elements */
  int size;
  /* array of 'int */
  int *image;
};

struct sparse_matrix;
struct sparse_array;

/* API */
extern struct sparse_matrix *anthy_sparse_matrix_new(void);
extern void anthy_sparse_matrix_set(struct sparse_matrix *m, int row, int column,
			     int value, void *ptr);
extern int anthy_sparse_matrix_get_int(struct sparse_matrix *m, int row, int column);
extern void anthy_sparse_matrix_make_matrix(struct sparse_matrix *m);
/* 󥤥᡼ۤAPI(host byte order) */
extern struct matrix_image *anthy_matrix_image_new(struct sparse_matrix *s);
/* 󥤥᡼˥¸ߤ뤫ݤ(network byte order), Patched by G-HAL, Mon,12 Oct,2009 */
extern int anthy_matrix_image_search_key( int* const image, int key );
/* 󥤥᡼˥API(network byte order) */
extern int anthy_matrix_image_peek(int *im, int row, int col);


#ifdef __cplusplus
}
#endif

#endif /* _matrix_h_included_ */
/* [ End of File ] */
/* vim:ts=8 sw=2 nomodified:
 */
