/*
 * ⥸塼Υ󥿡ե
 */
#ifndef _dic_h_included_
#define _dic_h_included_

#include "xstr.h"
#include "wtype.h"

#ifdef __cplusplus
extern "C" {
#endif


/** ɤߤФϥɥ(sequence entry) */
typedef struct seq_ent *seq_ent_t;
/***/
typedef struct dic_ent *compound_ent_t;

/* Τν */
extern int anthy_init_dic(void);
extern void anthy_quit_dic(void);

/* ¾ץФ¾ */
extern void anthy_lock_dic(void);
extern void anthy_unlock_dic(void);

/**/
extern void anthy_gang_load_dic(xstr *sentence, int is_reverse);

/* ʸμ */
extern seq_ent_t anthy_get_seq_ent_from_xstr(xstr *xs, int is_reverse);
/* ʸξ */
extern int anthy_get_nr_dic_ents(seq_ent_t se, xstr *xs);
extern int anthy_has_compound_ents(seq_ent_t se);
extern int anthy_has_non_compound_ents(seq_ent_t se);
extern int anthy_get_nth_dic_ent_is_compound(seq_ent_t se, int nth);
/* ʣ */
/* caller should free @res */
extern int anthy_get_nth_dic_ent_str(seq_ent_t se, xstr *orig, int n, xstr *x);
extern int anthy_get_nth_dic_ent_str_with_flagret(seq_ent_t, xstr *orig, int n, xstr *res, unsigned int* const extra_flag_ret );		/* Patched by G-HAL, Sun,02 Nov,2008 */
extern int anthy_get_nth_dic_ent_freq(seq_ent_t se, int nth);
extern int anthy_get_nth_dic_ent_wtype(seq_ent_t se, xstr *xs, int n, wtype_t *w);
extern int anthy_get_nth_dic_ent_wtname( const seq_ent_t se, int nth, const char* * const wt_name );	/* Patched by G-HAL, Wed,28 Oct,2009 */
/*  ʻ */
extern int anthy_get_seq_ent_pos(seq_ent_t se, int pos);
extern int anthy_get_seq_ent_ct(seq_ent_t se, int pos, int ct);
extern int anthy_get_seq_ent_wtype_freq(seq_ent_t seg, wtype_t wt);
extern int anthy_get_seq_ent_indep(seq_ent_t se);
/* ʣ */
extern compound_ent_t anthy_get_nth_compound_ent(seq_ent_t se, int nth);
extern int anthy_get_seq_ent_wtype_compound_freq(seq_ent_t se, wtype_t wt);
/**/
extern int anthy_compound_get_wtype(compound_ent_t ce, wtype_t *w);
extern int anthy_compound_get_freq(compound_ent_t ce);
extern int anthy_compound_get_nr_segments(compound_ent_t ce);
extern int anthy_compound_get_nth_segment_len(compound_ent_t ce, int nth);
extern int anthy_compound_get_nth_segment_xstr(compound_ent_t ce, int nth, xstr *xs);



/** 񥻥å
 *
 */
typedef struct mem_dic *dic_session_t;
/*typedef struct dic_session *dic_session_t;*/

extern dic_session_t anthy_dic_create_session(void);
extern void anthy_dic_activate_session(dic_session_t d);
extern void anthy_dic_release_session(dic_session_t d);

/* personality */
extern void anthy_dic_set_personality(const char *id);
extern void anthy_dic_set_personality_with_dicrefresh( const char *const id );	/* Patched by G-HAL, Wed,14 Jan,2009 */
/**/
#define ANON_ID ""


/** 㼭
 */
extern int anthy_dic_search_word_relation_key( int key );	/* Patched by G-HAL, Mon,12 Oct,2009 */
extern int anthy_dic_check_word_relation(int from, int to);

/** ̤θγؽ
 */
extern void anthy_add_unknown_word(xstr *yomi, xstr *word);
extern void anthy_forget_unused_unknown_word(xstr *xs);


#ifdef __cplusplus
}
#endif

#endif /* _dic_h_included_ */
/* [ End of File ] */
/* vim:ts=8 sw=2 nomodified:
 */
