<?php
final class Pager {
  const PAGE_ROWS = 20;
  private $totalRow = 0;
  private $currentPage = 1;
  public function __construct($totalRow, $currentPage) {
    $this->totalRow = $totalRow;
    $this->currentPage = $currentPage;
  }
  public function setTotalRow($totalRow) {
    $this->totalRow = $totalRow;
  }
  public function getTotalRow() {
    return $this->totalRow;
  }
  public function getStartRow() {
    return ($this->currentPage - 1) * Pager::PAGE_ROWS;
  }
  public function getTotalPage() {
    return ceil($this->totalRow / Pager::PAGE_ROWS);
  }
}
// EOF.
