<?php
require_once DTO . 'PlaceDto.php';
final class PlaceApply extends Action {
  private $dto;
  public function __construct() {
    $this->dto = new PlaceDto();
  }
  protected function getDto() {
    return $this->dto;
  }
  public function index() {
    session_start();
    if (!isset($_SESSION['DTO'])) {
      session_destroy();
      $_SESSION = array();
      return new Redirect('', DOMAIN);
    }
    $this->dto = unserialize($_SESSION['DTO']);
    session_destroy();
    $_SESSION = array();
    return new Forward();
  }
  public function apply() {
    session_start();
    if (!isset($_SESSION['DTO'])) {
      session_destroy();
      $_SESSION = array();
      return new Redirect('', DOMAIN);
    }
    $this->dto = unserialize($_SESSION['DTO']);
    $message = "掲載希望の企業様からお問い合わせ頂いた内容です。\n";
    $message .= "■会社名もしくは事業者様名\n" . mb_convert_kana($this->dto->shopName, 'KVa') . "\n";
    $message .= "■お名前\n" . mb_convert_kana($this->dto->name, 'KVa') . "\n";
    $message .= "■電話番号\n{$this->dto->telNo}\n";
    $message .= "■メールアドレス\n{$this->dto->email}\n";
    $message .= "■お問い合わせ内容\n{$this->dto->message}\n";
    mb_language('Ja');
    mb_internal_encoding('UTF-8');
    mb_send_mail('miura@tns-g.jp', '掲載希望企業様からのお問い合わせ', $message, 'From:Dear job<dear-job@tns-g.jp>');
    $_SESSION['DTO'] = serialize($this->dto);
    return new Redirect('place_apply', SSL);
  }
}
// EOF.
